# restoreDB {#restoredb}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`restoreDB(backupDir, dbPath, [newDBPath], [keyPath])`

## Arguments {#arguments}

**backupDir** is a string indicating the directory to save the backup.

**dbPath** is a string indicating the database path.

**newDBPath** \(optional\) is is a string indicating the new database name. The default value is *dbPath*.

**keyPath** \(optional, Linux only\) is a STRING scalar that specifies the path to the key file used for restoring an encrypted backup. The key version used for restoring the data must match the version specified during the backup. Note that when restoring an encrypted table, both the backup table and the target table must use the same encryption mode \(i.e., the same *encryptMode* parameter specified during table creation\).

## Details {#details}

Restore the backup database. Return a table where each row is the restored database and table name.

Similar to function [migrate](../m/migrate.md), the function can restore a database, and the difference lies in:

-   `migrate` can restore all databases and tables under a directory, while `restoreDB` can only restore a database.

-   If the names of restored database and tables are the same as the originals, the original databases and tables must be deleted before calling `migrate`, which is not required by function `restoreDB`.


Note:

-   This function can only restore a database backed up by copying files \(when dbPath is specified for function backup\).

-   Make sure that the storage engine of the backed-up database is the same as the engine of *newDBPath*, and the *partitionScheme* \(except for VALUE\) must be the same. For a VALUE partitioned database, the partitioning scheme of the backup database must be a subset of that of the database to be restored.


## Examples {#examples}

```
dbName = "dfs://compoDB2"
n=1000
ID=rand("a"+string(1..10), n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10, n)
t=table(ID, date, x)
db1 = database(, VALUE, 2017.08.07..2017.08.11)
db2 = database(, HASH,[INT, 20])
if(existsDatabase(dbName)){
     dropDatabase(dbName)
}
db = database(dbName, COMPO,[ db1,db2])

//create 2 tables
pt1 = db.createPartitionedTable(t, `pt1, `date`x).append!(t)
pt2 = db.createPartitionedTable(t, `pt2, `date`x).append!(t)

backupDB(backupDir, dbName)

restoreDB(backupDir, dbName)
```

|dbName|tableName|
|------|---------|
|dfs://compoDB2|pt1|
|dfs://compoDB2|pt2|

Related functions: [restore](restore.md), [restoreTable](restoreTable.md), [migrate](../m/migrate.md), [backup](../b/backup.md), [backupDB](../b/backupDB.md), [backupTable](../b/backupTable.md)

