# repmat {#repmat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`repmat(X, rowRep, colRep)`

## Arguments {#arguments}

**X** is a matrix.

**rowRep** and **colRep** are positive integers.

## Details {#details}

Create a large matrix consisting of a rowRep-by-colRep tiling of copies of *X*.

## Examples {#examples}

```
x=matrix(1 2 3, 4 5 6);
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
repmat(x, 2, 3);
```

|\#0|\#1|\#2|\#3|\#4|\#5|
|---|---|---|---|---|---|
|1|4|1|4|1|4|
|2|5|2|5|2|5|
|3|6|3|6|3|6|
|1|4|1|4|1|4|
|2|5|2|5|2|5|
|3|6|3|6|3|6|

