# reorderColumns! {#reordercolumns}

## Syntax {#syntax}

`reorderColumns!(table, reorderedColNames)`

## Arguments {#arguments}

**table** is an in-memory table that is not shared.

**reorderedColNames** is a string vector indicating column names. It specifies the order of columns after execution. We only need to write the names for the columns whose positions are changed and all columns before them in the new table. For example, if we switch the position of the 3th column and the 6th column, then we only need to specify the names of the first 6 columns.

## Details {#details}

Change the order of columns of an in-memory table. It modifies the original table instead of creating a new table.

## Examples {#examples}

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t = table(timestamp, sym, qty, price);
t;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|
|09:34:26|C|2500|50.32|
|09:38:12|C|8800|51.29|

```
reorderColumns!(t,`sym`timestamp`price`qty)
t;
```

|sym|timestamp|price|qty|
|---|---------|-----|---|
|C|09:34:07|49.6|2200|
|MS|09:36:42|29.46|1900|
|MS|09:36:51|29.52|2100|
|MS|09:36:59|30.02|3200|
|IBM|09:32:47|174.97|6800|
|IBM|09:35:26|175.23|5400|
|C|09:34:16|50.76|1300|
|C|09:34:26|50.32|2500|
|C|09:38:12|51.29|8800|

```
reorderColumns!(t,`timestamp`sym);
t;
```

|timestamp|sym|price|qty|
|---------|---|-----|---|
|09:34:07|C|49.6|2200|
|09:36:42|MS|29.46|1900|
|09:36:51|MS|29.52|2100|
|09:36:59|MS|30.02|3200|
|09:32:47|IBM|174.97|6800|
|09:35:26|IBM|175.23|5400|
|09:34:16|C|50.76|1300|
|09:34:26|C|50.32|2500|
|09:38:12|C|51.29|8800|

