# renameCatalogName {#renameCatalogName}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`renameCatalogName(catalog, schema, oldName, newName)`

## Arguments {#arguments}

**catalog** is a string specifying the catalog name.

**schema** is a string specifying the schema name, which is one of "orca\_graph", "orca\_table", or "orca\_engine".

**oldName**is a string specifying the name before modification.

**newName**is a string indicating the name after modification.

## Details {#details}

Modifies the name in the fully qualified name `<catalog>.<schema>.<name>`.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
renameCatalogName(catalog="demo1", schema="orca_graph", oldName="factor1", newName="factor2")

renameCatalogName(catalog="demo2", schema="orca_engine", oldName="engine1", newName="engine2")

renameCatalogName(catalog="demo3", schema="orca_table", oldName="trades1", newName="trades2")
```

