# remoteRunCompatible {#remoteruncompatible}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`remoteRunCompatible(conn, script, args...)`

## Arguments {#arguments}

**conn** represents a database connection.

**script** is a string indicating the script or function name to be executed on the remote node.

**args**... \(optional\) are the parameters for the function to be executed if *script* is a function name. It can have 0 or multiple items.

## Details {#details}

Send a script or function to a remote database for execution.

Compared to `remoteRun`, `remoteRunCompatible` works across all database versions. The `remoteRun` function requires version compatibility when the local server is 3.00 or higher.

## Examples {#examples}

The first use case: *script* is the script.

Execute script on a remote node.

``` {#codeblock_eyj_yvj_zbc}
conn =  xdb(host="localhost",port=8848,userId="admin",password=123456);
remoteRunCompatible(conn, "avg(1..100)");

// output: 50.5
```

The second use case: *script* is a function name.

-   If it is quoted: execute a remote function on a remote node. The function is defined on the remote node, while the parameters of the function are given on the local node.


``` {#codeblock_hyj_yvj_zbc}
// create a function view on the remote node
def myAvg(x){
  return avg(x)+2
}
addFunctionView(myAvg)

// execute function view "myAvg"
conn =  xdb("localhost",8848,`admin,`123456);
remoteRunCompatible(conn, "myAvg", 1..100);

// output: 52.5
```

-   If it is not quoted: execute a local function on a remote node. The parameters of the function are given on the local node.


``` {#codeblock_kyj_yvj_zbc}
// define function "myAvg" on the local node
def myAvg(x){
  return avg(x)+1
}

// execute "myAvg" function on the remote node
conn =  xdb("localhost",8848,`admin,`123456);
remoteRunCompatible(conn, myAvg, 1..100);

// output: 51.5
```

Related function: remoteRun

