# regexReplace {#regexreplace}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`regexReplace(str, pattern, replacement, [offset])`

## Arguments {#arguments}

**str** is a string or a string vector.

**pattern** is an ordinary string scalar or a regular expression pattern to be searched in *str*. Regular expression pattern includes character literals, metacharacters, or a combination of both.

**replacement** is a string scalar. It is used to replace pattern in *str*.

**offset** \(optional\) is a non-negative integer with default value of 0. This optional argument is the starting position in *str* to conduct the search and replace operation. The first character in *str* corresponds to positive 0.

## Details {#details}

Search in *str* for another string that matches *pattern* and and replace every occurrence of the matched string or pattern with *replacement*.

## Examples {#examples}

```
regexReplace("abc234 ff456", "[a-z]", "z");
// output: zzz234 zz456

regexReplace("abc234 ff456", "[a-z]+", "zzz");
// output: zzz234 zzz456

regexReplace("abc234 ff456", "[0-9]+", "zzz");
// output: abczzz ffzzz
```

