# regexFind {#regexfind}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`regexFind(str, pattern, [offset])`

## Arguments {#arguments}

**str** is a string or a string vector.

**pattern** is an ordinary string scalar or a regular expression pattern to be searched in *str*. Regular expression pattern includes character literals, metacharacters, or a combination of both.

**offset** \(optional\) is a non-negative integer with default value of 0. This optional argument is the starting position in *str*to conduct the search operation. The first character in *str* corresponds to position 0.

## Details {#details}

Search in *str* for another string that matches *pattern* and return an integer that indicates the beginning position of the first matched substring. If no substring matches, return -1.

## Examples {#examples}

```
regexFind("1231hsdU777_ DW#122ddd", "[a-z]+");
// output: 4

regexFind("1231hsdU777_ DW#122ddd", "[0-9]+");
// output: 0

regexFind("1231hsdU777_ DW#122ddd", "[0-9]+", 4);
// output: 8
```

