# rebalanceChunksAmongDataNodes {#rebalancechunksamongdatanodes}

## Syntax {#syntax}

`rebalanceChunksAmongDataNodes([exec = false], [updatedBeforeDays = 7.0])`

## Argument {#arguments}

**exec** \(optional\) is a Boolean value indicating whether to initiate data rebalancing. The default value is false, meaning that data rebalancing will not be executed and only the rebalancing plan will be returned.

**updatedBeforeDays** \(optional\) is a non-negative floating-point number, which limits the rebalancing process to only include chunks that were updated before *updatedBeforeDays*. The default value is 7 \(in days\).

## Details {#details}

This function is used to rebalance data among disks for optimal performance after a cluster is scaled up. It can only be executed on a controller by an administrator.

Return a table containing the following columns:

|name|meaning|
|----|-------|
|chunkId|the chunk ID|
|srcNode|alias of source node|
|destNode|alias of destination node|
|destVolume|destination volume|

After invoking this function, the system will print INFO-level logs that include the disk usage rate before and after rebalancing, in the following format:

``` {#codeblock_gjc_3fd_2bc}
[rebalance] Expected change of disk usage rate is before -> after
[rebalance] Change of disk usage rate in IP@fsid(1/disk count) is before -> after
[rebalance] Change of disk usage rate in IP@fsid(2/disk count) is before -> after
...
```

You can get the status of recovery tasks by [getRecoveryTaskStatus](../g/getRecoveryTaskStatus.md) on a controller.

## Example {#example}

```
rebalanceChunksAmongDataNodes()
```

|srcNode|chunkId|destNode|destVolume|
|-------|-------|--------|----------|
|node1|99279094-ca12-3b87-48b6-520cbb986f39|node2|/home/xxx/node2/storage|
|node1|45f612b8-42f5-aebd-4cef-e522b6ae1fc8|node2|/home/xxx/node2/storage|

