# readBytes {#readbytes}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`readBytes(fileHandle, sizeInByte)`

## Arguments {#arguments}

**fileHandle** is the handle of the file to read.

**sizeInByte** is an integer indicating the number of bytes to read.

## Details {#details}

Read the given number of bytes from the handle. If the file reaches the end or an IO error occurs, an IOException will be raised; otherwise a buffer containing the given number of bytes will return. We must know the exact number of bytes to read before calling this function.

## Examples {#examples}

This example defines a function to copy a file:

```
def fileCopy(source, target){
s = file(source)
len = s.seek(0,TAIL)
s.seek(0,HEAD)
t = file(target,"w")
if(len==0) return
do{
  buf = s.readBytes(min(len,1024))
  t.writeBytes(buf)
  len -= buf.size()
}while(len)
};
fileCopy("test.txt","testcopy.txt");
```

