# rdp {#rdp}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rdp(pointList, epsilon)`

## Arguments {#arguments}

**pointList** is a POINT vector which cannot contain null values.

**epsilon** is a non-negative DOUBLE type scalar that represents the compression threshold.

## Details {#details}

Use RDP \(Ramer-Douglas-Peucker\) vector compression algorithm to compress the POINT type vector.

## Examples {#examples}

```
pt = point(1 2 3 4, 1 2 3 4)
rdp(pt, 0.1)
// output: [(1.0, 1.0), (4.0, 4.0)]
​
pt = point(1 2 3 4, 1 3 3 4)
rdp(pt, 0.1)
// output: [(1.0, 1.0), (2.0, 3.0), (3.0, 3.0), (4.0, 4.0)]

temp = array(POINT,0)
n=90000
x_data = rand(10.0,n)
y_data = rand(10.0,n)
index=0
do{
temp.append!(point(x_data[index], y_data[index]))
index += 1
}while(index<n)
s=rdp(temp, 0.8)
print(s.size())
// output: 82002
print(temp.size())
// output: 90000
```

