# ratios {#ratios}

## Syntax {#syntax}

`ratios(X)`

## Arguments {#arguments}

**X** is a vector or a matrix.

## Details {#details}

If *X* is a vector, return X\(n\)\\X\(n-1\) by scanning *X*. The first element of the result is always null.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
x=3 12 0 -5 32;
ratios x;
// output: [,4,0,,-6.4]

x=2 3 6 NULL 28 7;
ratios x;
// output: [,1.5,2,,,0.25]

m=matrix(100 105 109 112 108 116, 200 212 208 199 206 210);
m;
```

|\#0|\#1|
|---|---|
|100|200|
|105|212|
|109|208|
|112|199|
|108|206|
|116|210|

```
ratios(m);
```

|\#0|\#1|
|---|---|
| | |
|1.05|1.06|
|1.038095238095238|0.981132075471698|
|1.027522935779817|0.956730769230769|
|0.964285714285714|1.035175879396985|
|1.074074074074074|1.019417475728155|

