# rank {#rank}

## Syntax {#syntax}

`rank(X, [ascending=true], [groupNum], [ignoreNA=true], [tiesMethod='min'], [percent=false], [precision])`

## Arguments {#arguments}

**X** is a vector/matrix/table/dictionary.

**ascending** \(optional\) is a Boolean value indicating whether the sorting is in ascending order. The default value is true \(ascending\).

**groupNum** \(optional\) is a positive integer indicating the number of groups to sort X into.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored.

**tiesMethod** \(optional\) is a string indicating how to rank the group of elements with the same value \(i.e., ties\):

-   'min' : the smallest rank value of the tie values.

-   'max' : the largest rank value of the tie values.

-   'average' : the average of the rank values for all ties.

-   'first': Gives the first found tie value the lowest rank value, and continues with the following rank value for the next tie.


**percent** \(optional\) is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

**precision** \(optional\) is an integer between \[1, 15\]. If the absolute difference between two values is no greater than 10^\(-precision\), the two values are considered to be equal.

**Note:**

If parameter *precision* is specified, *X* must be numeric, and the *tiesMethod* cannot be specified as 'first'.

## Details {#details}

Based on the sort order specified by *ascending*, this function returns the ranking \(starting from 0\) of each element in *X*.

If *X* is a vector, return a vector with the same length as *X*:

-   If *groupNum* is specified, divide the sorted vector *X* into *groupNum* groups and return the group number \(starting from 0\) for each element in *X*.

    -   If the number of elements in *X* cannot be divided by *groupNum*, the first *mod\(size\(X\), groupNum\)* groups will hold one more element. For example, *X* has 6 elements, groupNum is specified as 4, the first and second elements of sorted vector *X* belong to group 0, the third and fourth elements belong to group 1, and the fifth and sixth elements belong to groups 2 and 3, respectively.

    -   If the identical elements are not divided in the same group, return the smallest group number for all identical elements.

-   If *ignoreNA* = true, null values are ignored and return NULL.


If *X* is a matrix/table, conduct the aforementioned calculation within each column of *X*. The result is a matrix/table with the same shape as *X*.

If *X* is a dictionary, the ranking is based on its values, and the ranks of all elements are returned.

## Examples {#examples}

```
rank(45 16 32 21);
// output: [3,0,2,1]

rank(45 16 32 21, false);
// output: [0,3,1,2]

rank(9 1 6 1 3 3);
// output: [5,0,4,0,2,2]
// two identical elements have the same ranking.

rank(X=9 5 4 8 1 3 6 2 7, groupNum=3);
// output: [2,1,1,2,0,0,1,0,2]

rank(X=9 5 4 8 1 3 6 2 7, ascending=false, groupNum=3);
// output: [0,1,1,0,2,2,1,2,0]

rank(X=1 2 2 3, tiesMethod='min');
// output: [0,1,1,3]

rank(X=1 2 2 3, tiesMethod='average');
// output: [0,1.5,1.5,3]

rank(X=1 2 2 3, tiesMethod='first');
// output: [0,1,2,3]

rank(1 NULL NULL 3);
// output: [0,,,1]

rank(X=1 NULL NULL 3, ignoreNA=false);
// output: [2,0,0,3]

t=table(1 1 1 2 2 2 2 as id, 3 5 4 6 2 7 1 as x)
t
```

|id|x|
|---|---|
|1|3|
|1|5|
|1|4|
|2|6|
|2|2|
|2|7|
|2|1|

```
select *, rank(x) from t context by id;
```

|id|x|rank\_x|
|---|---|-------|
|1|3|0|
|1|5|2|
|1|4|1|
|2|6|2|
|2|2|1|
|2|7|3|
|2|1|0|

``` {#codeblock_ajr_4zd_ngc}
rank(dict(`a`b`c, [4, 1, 2],true))
// output: [2, 0, 1]
```

