# randMultivariateNormal {#randmultivariatenormal}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`randMultivariateNormal(mean, covar, count, [sampleAsRow=true])`

Alias: multivariateNormal

## Arguments {#arguments}

**mean** is a vector indicating the mean of a normal distribution.

**covar** is a positive definite matrix indicating the variance-covariance matrix of a multivariate normal distribution.

**count** is a positive number indicating the number of samples to be generated.

**sampleAsRow** \(optional\) is a Boolean value. The default value is true indicating each row of the result is a sample. Otherwise each column of the result is a sample.

## Details {#details}

Return a matrix of random values that follow a multivariate normal distribution.

## Examples {#examples}

```
multivariateNormal([2, 3], [1.0, 1.5, 1.5, 3.0]$2:2, 5);
```

|\#0|\#1|
|---|---|
|-0.02395|-0.844505|
|-0.630637|0.098955|
|3.001908|4.831809|
|0.791095|2.01402|
|1.708191|2.41748|

```
multivariateNormal([2, 3], [1.0, 1.5, 1.5, 3.0]$2:2, 5, false);
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|0.435419|0.138209|-0.046187|-1.201421|0.069719|
|0.40163|0.034553|-0.337324|-1.008628|0.822161|

