# randDiscrete {#randdiscrete}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`randDiscrete(v, p, count)`

## Arguments {#arguments}

**v** is a vector/tuple indicating the sample data.

**p** is a vector of floating point type of the same length as *v*. Each element in p must be a positive number, indicating the probability distribution of *v*.

**count** is a positive integer indicating the length of the output vector.

## Details {#details}

Generate a sample of size count with random values sampling from *v* based on the specified probability distribution *p*.

## Examples {#examples}

```
randDiscrete(1..5, [0.1, 0.1, 0.2, 0.2, 0.4], 10)
// output: [2,3,5,2,5,5,2,1,1,2]

//If the sum of p is not 1, it will be normalized automatically.
randDiscrete(1..5, [0.1, 0.2, 0.3, 0.4, 0.5], 5)
// output: [5,1,2,3,5]

randDiscrete(`A`B`C`E`F, [0.1, 0.2, 0.3, 0.4, 0.5], 5)
// output: ["C","E","B","C","F"]

// Sample from each element in a tuple.
randDiscrete([[1,2], [2,3,4], 'S', 'abc'], [0.3, 0.3, 0.2, 0.1], 10)
// output: ('S',[2,3,4],[1,2],[2,3,4],[1,2],'S','S',[2,3,4],[2,3,4],[2,3,4])

// Sample from each vector in an array vector.
a = array\(INT\[\], 0, 10\).append!\(\[1 2 3, 4 5,6 7 8, 9 NULL\]\)
randDiscrete\(a, \[0.1, 0.2, 0.3, 0.4\], 10\)
// output: \[\[9,00i\],\[9,00i\],\[9,00i\],\[4,5\],\[9,00i\],\[1,2,3\],\[9,00i\],\[6,7,8\],\[9,00i\],\[9,00i\]\]
```

