# quantile {#quantile}

## Syntax {#syntax}

`quantile(X, q, [interpolation='linear'])`

## Arguments {#arguments}

**X** is a numeric vector, matrix or table.

**q** is a floating number between 0 and 1.

**interpolation** is a string indicating how to interpolate if the quantile is between element i and j in *X* with i&lt;j. It can take the following values:

-   'linear' \(default\): i+\(j-i\)\*fraction, where fraction is the decimal part of *q*\*size\(X\).

-   'lower': i

-   'higher': j

-   'nearest': i or j whichever is nearest.

-   'midpoint': \(i+ j\)/2


## Details {#details}

Return values at the given quantile in *X*.

## Examples {#examples}

```
a=[6, 47, 49, 15, 42, 41, 7, 39, 43, 40, 36];
quantile(a,0.25);
// output: 25.5

quantile(a,0.5);
// output: 40

quantile(a,0.75);
// output: 42.5

quantile(a,0.75, 'lower');
// output: 42
```

Related function: [quantileSeries](quantileSeries.md), [percentile](../p/percentile.md)

