# qr {#qr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`qr(obj, [mode='full'], [pivoting=false])`

## Arguments {#arguments}

**obj** is a matrix.

**mode** is a string indicating what information is to be returned. It can be "full", "economic" or "r". The default value is "full".

**pivoting** is a Boolean value. The default value is false.

## Details {#details}

Perform the QR decomposition of a matrix. Decompose a matrix A into an orthogonal matrix Q and an upper triangular matrix R, with A=Q\*R.

Given an m-by-n matrix A:

-   If *mode*="full", return 2 matrices: Q \(m-by-m\) and R \(m-by-n\).

-   If *mode*="economic", return 2 matrices: Q \(m-by-k\) and R \(k-by-n\) with k=min\(m,n\).

-   If *mode*="r", only return matrix R \(m-by-n\).


If *pivoting*= true, also return a vector P which has the same length as the number of columns of the matrix. P is the pivoting for rank-revealing QR decomposition indicating the location of 1s in the permutation matrix.

## Examples {#examples}

```
A = matrix([2,5,7,5], [5,2,5,4], [8,2,6,4]);

Q,R = qr(A);
Q;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|-0.197066|0.903357|0.300275|0.234404|
|-0.492665|-0.418267|0.459245|0.609449|
|-0.68973|-0.02475|0.170745|-0.703211|
|-0.492665|0.091573|-0.818398|0.281284|

```
R;
```

|\#0|\#1|\#2|
|---|---|---|
|-10.148892|-7.38997|-8.670898|
|0|3.922799|6.608121|
|0|0|1.071571|
|0|0|0|

```
Q,R=qr(A,mode='economic');
Q;
```

|\#0|\#1|\#2|
|---|---|---|
|-0.197066|0.903357|0.300275|
|-0.492665|-0.418267|0.459245|
|-0.68973|-0.02475|0.170745|
|-0.492665|0.091573|-0.818398|

```
R;
```

|\#0|\#1|\#2|
|---|---|---|
|-10.148892|-7.38997|-8.670898|
|0|3.922799|6.608121|
|0|0|1.071571|

```
Q,T,R=qr(A,mode='raw');
R;
```

|\#0|\#1|\#2|
|---|---|---|
|-10.148892|-7.38997|-8.670898|
|0.41156|3.922799|6.608121|
|0.576184|0.3046|1.071571|
|0.41156|0.156539|0.900419|

```
T;
// output: [1.197066,1.790053,1.104512]

R
```

|\#0|\#1|\#2|
|---|---|---|
|-10.148892|-7.38997|-8.670898|
|0|3.922799|6.608121|
|0|0|1.071571|

```
Q,T,R,P = qr(A,mode='raw',pivoting=true);
Q;
```

|\#0|\#1|\#2|
|---|---|---|
|-10.954451|-8.033264|-8.215838|
|0.105516|-6.20215|-1.45111|
|0.316548|0.37699|-0.627918|
|0.211032|0.284188|0.936372|

```
T;
// output: [1.730297,1.635478,1.065648]

R
```

|\#0|\#1|\#2|
|---|---|---|
|-10.954451|-8.033264|-8.215838|
|0|-6.20215|-1.45111|
|0|0|-0.627918|

```
P;
// output: [2,0,1]
```

