# Python-DolphinDB Equivalents {#py_func_mappings}

This page gives rough equivalents for Python functions. The DolphinDB functions listed below are supported in version 2.00 or above.

The following python libraries are covered:

1.  Python built-in function
2.  NumPy
3.  pandas
4.  SciPy
5.  statsmodels
6.  sklearn
7.  TA-Lib

**Parent topic:**[Function References](../Functions/chap_function_references.md)

## Python built-in function {#topic_ltt_prz_c2c}

|Python|DolphinDB|
|------|---------|
|==|eq|
|abs|abs|
|all|all|
|any|any|
|bool|bool|
|dict|dict|
|equals|eqObj|
|format|strReplace|
|in|in|
|int|int|
|itertools.product|cross + join|
|join|concat|
|lead / lag|move|
|len|strlen / size|
|pow|pow|
|print|print|
|rjust /zfill|lpad /rpad|
|round|round|
|set|set|
|slice|slice|
|sort|isort|
|str|string|
|type|type / typestr|
|zip|loop\(pair, x, y\)|

## NumPy {#topic_yqm_xrz_c2c}

|NumPy|DolphinDB|
|-----|---------|
|numpy.argsort|isort/isort!|
|numpy.averge\(weight\)|wavg|
|numpy.clip|winsorize|
|numpy.corrcoef|corrMatrix|
|numpy.cov|covarMatrix|
|numpy.cov\(fweights\)|wcovar|
|numpy.digitize|digitize|
|numpy.max|max|
|numpy.mean|mean/avg|
|numpy.median|med|
|numpy.min|min|
|numpy.percentile / pandas.Series.percentile|percentile|
|numpy.quantile|quantileSeries|
|numpy.quantile / pandas.Series.quantile|quantile|
|numpy.random.beta|randBeta|
|numpy.random.binomial|randBinomial|
|numpy.random.chisquare|randChiSquare|
|numpy.random.exponential|randExp|
|numpy.random.f|randF|
|numpy.random.gamma|randGamma|
|numpy.random.logistic|randLogistic|
|numpy.random.multivariate\_normal|randMultivariateNormal|
|numpy.random.normal|randNormal|
|numpy.random.normal|norm|
|numpy.random.poisson|randPoisson|
|numpy.random.rand|rand|
|numpy.random.standard\_t|randStudent|
|numpy.random.uniform|randUniform|
|numpy.random.weibull|randWeibull|
|numpy.std|stdp|
|numpy.std\(ddof=1\)|std|
|numpy.sum|sum|
|numpy.var|varp|
|numpy.var\(ddof=1\)|var|

## pandas {#topic_ary_1sz_c2c}

|pandas|DolphinDB|
|------|---------|
|df\[column\]|at|
|pandas.concat|concatMatrix|
|pandas.DataFrame.add / pandas.Series.add|withNullFill + add|
|pandas.DataFrame.append / pandas.Series.append|append!|
|pandas.DataFrame.astype / pandas.Series.astype|cast|
|pandas.DataFrame.bfill / pandas.Series.bfill|bfill/bfill!|
|pandas.DataFrame.corr / pandas.Series.corr|corr|
|pandas.DataFrame.count / pandas.Series.count|count|
|pandas.DataFrame.cummax / pandas.Series.cummax|cummax|
|pandas.DataFrame.cummin / pandas.Series.cummin|cummin|
|pandas.DataFrame.cumprod / pandas.Series.cumprod|cumprod|
|pandas.DataFrame.cumsum / pandas.Series.cumsum|cumsum|
|pandas.DataFrame.describe / pandas.Series.describe|summary|
|pandas.DataFrame.diff / pandas.Series.diff|eachPost, deltas|
|pandas.DataFrame.div / pandas.Series.div|withNullFill + div / ratio|
|pandas.DataFrame.drop / pandas.Series.drop|dropColumns!|
|pandas.DataFrame.dropna / pandas.Series.dropna|dropna|
|pandas.DataFrame.ewm.corr|ewmCorr|
|pandas.DataFrame.ewm.cov|ewmCov|
|pandas.DataFrame.ewm.mean|ewmMean|
|pandas.DataFrame.ewm.var|ewmVar|
|pandas.DataFrame.ffill / pandas.Series.ffill|ffill/ffill!|
|pandas.DataFrame.fillna / pandas.Series.fillna|nullFill/nullFill!|
|pandas.DataFrame.groupby.aggFunc|regroup, group by|
|pandas.DataFrame.head / pandas.Series.head|head|
|pandas.DataFrame.hist / pandas.Series.hist|plotHist|
|pandas.DataFrame.idxmax / pandas.Series.idxmax|imax|
|pandas.DataFrame.idxmin / pandas.Series.idxmin|imin|
|pandas.DataFrame.interpolate / pandas.Series.interpolate|interpolate|
|pandas.DataFrame.interpolate\(method='linear'\) / pandas.Series.interpolate\(method='linear'\)|lfill/lfill!|
|pandas.DataFrame.isin / pandas.Series.isin|in|
|pandas.DataFrame.isnull/pandas.DataFrame.isna|isNull|
|pandas.DataFrame.keys / pandas.Series.keys|rowNames / columnNames|
|pandas.DataFrame.kurt\(kurtosis\) / pandas.Series.kurt\(kurtosis\)|kurtosis|
|pandas.DataFrame.mad / pandas.Series.mad|mad \(useMedian=false\)|
|pandas.DataFrame.mask / pandas.Series.mask|mask|
|pandas.DataFrame.max / pandas.Series.max|max|
|pandas.DataFrame.mean / pandas.Series.mean|mean/avg|
|pandas.DataFrame.median / pandas.Series.median|med|
|pandas.DataFrame.melt|unpivot|
|pandas.DataFrame.merge / pandas.DataFrame.join|merge|
|pandas.DataFrame.min / pandas.Series.min|min|
|pandas.DataFrame.mul / pandas.Series.mul|withNullFill + mul|
|pandas.DataFrame.nlargest\(nsmallest\) / pandas.Series.nlargest\(nsmallest\)|top + order by / aggrTopN|
|pandas.DataFrame.notnull/pandas.DataFrame.notna|isValid|
|pandas.DataFrame.nunique / pandas.Series.nunique|nunique|
|pandas.DataFrame.pivot|pivot / panel|
|pandas.DataFrame.prod / pandas.Series.prod|prod|
|pandas.DataFrame.quantile / pandas.Series.quantile|quantile|
|pandas.DataFrame.rename|rename!|
|pandas.DataFrame.rolling / pandas.Series.rolling|moving|
|pandas.DataFrame.sem / pandas.Series.sem|sem|
|pandas.DataFrame.shift / pandas.Series.shift|move / tmove / prev / next|
|pandas.DataFrame.skew / pandas.Series.kurt\(skew\)|skew|
|pandas.DataFrame.sort\_values / pandas.Series.sort\_values|sort/sort!|
|pandas.DataFrame.std / pandas.Series.std|std|
|pandas.DataFrame.sub / pandas.Series.sub|withNullFill + sub|
|pandas.DataFrame.sum / pandas.Series.sum|sum|
|pandas.DataFrame.tail / pandas.Series.tail|tail|
|pandas.DataFrame.to\_json / pandas.Series.to\_json|toJson|
|pandas.DataFrame.transpose|transpose|
|pandas.ewmstd|ewmStd|
|pandas.read\_csv|loadText / loadTextEx|
|pandas.read\_json|fromJson|
|pandas.rolling\_mean|mavg|
|pandas.rolling\_median|mmed|
|pandas.rolling\_std|mstd|
|pandas.Series.align / pandas.DataFrame.align|align|
|pandas.Series.between|between|
|pandas.Series.copy / pandas.DataFrame.copy|copy|
|pandas.Series.cov|covar|
|pandas.Series.describe / pandas.DataFrame.describe 类似|stat|
|pandas.Series.duplicated /pandas.DataFrame.duplicated|isDuplicated|
|pandas.Series.iat / pandas.DataFrame.iat|cell|
|pandas.Series.iloc / pandas.DataFrame.iloc|cells|
|pandas.Series.is\_monotonic\_decreasing|isMonotonicIncreasing|
|pandas.Series.is\_monotonic\_increasing|isMonotonicDecreasing|
|pandas.Series.loc / pandas.DataFrame.loc|loc|
|pandas.Series.rank / pandas.DataFrame.rank|rank|
|pandas.Series.rank\(method='dense'\) / pandas.DataFrame.rank\(method='dense'\)|denseRank|
|pandas.Series.resample / pandas.DataFrame.resample|resample|
|pandas.Series.str.endswith|endsWith|
|pandas.Series.str.find|regexFind|
|pandas.Series.str.isalnum|isAlNum|
|pandas.Series.str.isalpha|isAlpha|
|pandas.Series.str.isdecimal|isDecimal|
|pandas.Series.str.isdigit|isDigit|
|pandas.Series.str.islower|isLower|
|pandas.Series.str.isnumeric|isNumeric|
|pandas.Series.str.isspace|isSpace|
|pandas.Series.str.istitle|isTitle|
|pandas.Series.str.isupper|isUpper|
|pandas.Series.str.replace|strReplace|
|pandas.Series.str.startswith|startsWith|
|pandas.to\_csv|saveText|
|pandas.to\_datetime|temporalParse|
|pandas.unique / pandas.DataFrame.unique / pandas.Series.unique|distinct|

## SciPy {#topic_pts_2sz_c2c}

|SciPy|DolphinDB|
|-----|---------|
|scipy.interpolate.CubicHermiteSpline|cubicHermiteSplineFit|
|scipy.interpolate.KroghInterpolator|kroghInterpolate|
|scipy.spatial.distance.euclidean|euclidean|
|scipy.stats.beta.cdf\(X, a, b\)|cdfBeta\(a, b, X\)|
|scipy.stats.beta.ppf\(X, a, b\)|invBeta|
|scipy.stats.binom.cdf\(X, trials, p\)|cdfBinomial\(trials, p, X\)|
|scipy.stats.binom.ppf\(X, trials, p\)|invBinomial|
|scipy.stats.boxcox|boxcox|
|scipy.stats.chi2.cdf\(x, df\)|cdfChiSquare\(df, X\)|
|scipy.stats.chi2.pdf|pdfChiSquare|
|scipy.stats.chi2.ppf\(x, df\)|invChiSquare|
|scipy.stats.chisquare|chiSquareTest|
|scipy.stats.expon.cdf\(x, scale=mean\)|cdfExp\(mean, X\)|
|scipy.stats.expon.ppf\(x, scale=mean\)|invExp|
|scipy.stats.f\_oneway|fTest|
|scipy.stats.f.cdf\(X, dfn, dfd\)|cdfF\(dfn, dfd, X\)|
|scipy.stats.f.pdf|pdfF|
|scipy.stats.f.ppf\(X, dfn, dfd\)|invF|
|scipy.stats.gamma.cdf\(X, shape, scale=scale\)|cdfGamma\(shape, scale, X\)|
|scipy.stats.gamma.ppf\(X, shape, scale=scale\)|invGamma|
|scipy.stats.ks\_2samp|ksTest|
|scipy.stats.kurtosis|kurtosis|
|scipy.stats.logistic.cdf\(X, loc=mean,scale=scale\)|cdfLogistic\(mean, scale, X\)|
|scipy.stats.logistic.ppf\(X, loc=mean,scale=scale\)|invLogistic|
|scipy.stats.mannwhitneyu|mannWhitneyUTest|
|scipy.stats.mstats.winsorize|winsorize|
|scipy.stats.norm.cdf\(X, loc=mean, scale=stdev\)|cdfNormal\(mean,stdev,X\)|
|scipy.stats.norm.pdf|pdfNormal|
|scipy.stats.norm.ppf\(X, loc=mean, scale=stdev\)|invNormal|
|scipy.stats.percentileofscore|percentileRank|
|scipy.stats.poisson.cdf\(X, mu=mean\)|cdfPoisson\(mean, X\)|
|scipy.stats.poisson.ppf\(X, mu=mean\)|invPoisson|
|scipy.stats.sem|sem|
|scipy.stats.shapiro|shapiroTest|
|scipy.stats.skew|skew|
|scipy.stats.spearmanr\(X, Y\)\[0\]|spearmanr\(X, Y\)|
|scipy.stats.t.cdf\(X, df\)|cdfStudent\(df, X\)|
|scipy.stats.t.ppf\(X, df\)|invStudent|
|scipy.stats.ttest\_ind|tTest|
|scipy.stats.uniform.cdf\(X, loc=lower, scale=upper-lower\)|cdfUniform\(lower, upper, X\)|
|scipy.stats.uniform.ppf\(X, loc=lower, scale=upper-lower\)|invUniform|
|scipy.stats.weibull\_min.cdf\(X, alpha, scale=beta\)|cdfWeibull\(alpha, beta, X\)|
|scipy.stats.weibull\_min.ppf\(X, alpha, scale=beta\)|invWeibull|
|scipy.stats.zipfian.cdf\(X, exponent, num\)|cdfZipf\(num, exponent, X\)|
|scipy.stats.zscore\(ddof=1\)|zscore|

## statsmodels {#topic_kb1_jsz_c2c}

|statsmodels|DolphinDB|
|-----------|---------|
|statsmodels.api.stats.anova\_lm|anova|
|statsmodels.api.tsa.acf|acf|
|statsmodels.multivariate.manova.MANOVA|manova|
|statsmodels.regression.linear\_model.OLS|olsolsEx|
|statsmodels.regression.linear\_model.WLS|wls|
|statsmodels.stats.weightstats.ztest|zTest|
|statsmodels.tsa.arima.model.ARIMA|arima|
|statsmodels.tsa.seasonal.STL|stl|

## sklearn {#topic_x1x_3sz_c2c}

|sklearn|DolphinDB|
|-------|---------|
|sklearn.cluster.k\_means|kmeans|
|sklearn.decomposition.PCA|pca|
|sklearn.ensemble.AdaBoostClassifier|adaBoostClassifier|
|sklearn.ensemble.AdaBoostRegressor|adaBoostRegressor|
|sklearn.ensemble.RandomForestClassifier|randomForestClassifier|
|sklearn.ensemble.RandomForestRegressor|randomForestRegressor|
|sklearn.linear\_model.ElasticNet|elasticNet|
|sklearn.linear\_model.Lasso|lasso|
|sklearn.linear\_model.LinearRegression\(\).fit\(Y, X\).coef\_|beta\(X, Y\)|
|sklearn.linear\_model.LogisticRegression|logisticRegression|
|sklearn.linear\_model.Ridge|ridge|
|sklearn.metrics.mutual\_info\_score|mutualInfo|
|sklearn.mixture.GaussianMixture|gmm|
|sklearn.naive\_bayes.GaussianNB|gaussianNB|
|sklearn.naive\_bayes.MultinomialNB|multinomialNB|
|sklearn.neighbors.KNeighborsClassifier|knn|

## TA-Lib {#topic_s3v_3sz_c2c}

|TA-Lib|DolphinDB|
|------|---------|
|talib.DEMA|dema|
|talib.EMA|ema|
|talib.KAMA|kama|
|talib.LINEARREG\_SLOPE / talib.LINEARREG\_INTERCEPT|linearTimeTrend|
|talib.MA|ma|
|talib.SMA|sma|
|talib.T3|t3|
|talib.TEMA|tema|
|talib.TRANGE|trueRange|
|talib.TRIMA|trima|
|talib.WMA|wma|

The functions listed above are DolphinDB built-in functions. More TA-lib functions are provided in DolphinDB ta module. Refer to [DolphinDB tutorial: Technical Analysis Indicator Library](../Tutorials/ta.md) for more information.

**Note:** Contact us via [support@dolphindb.com](mailto:support@dolphindb.com) or comment below to send us feedback or report any problems you find.

