# pwlfPredict {#pwlfPredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`pwlfPredict(model, X, [beta], [breaks])`

## Arguments {#arguments}

**model** is a dictionary returned by `piecewiseLinFit`.

**X** is a numeric vector indicating the x locations to predict the output of the fitted continuous piecewise linear function. Null value is not allowed.

**beta** \(optional\) is a numeric vector indicating the model parameters for the continuous piecewise linear fit. Null value is not allowed.

**breaks** \(optional\) is a numeric vector indicating the x locations where each line segment terminates. These are referred to as breakpoints for each line segment. Null value is not allowed.

## Details {#details}

Evaluate the fitted continuous piecewise linear function at untested points.

**Return value**: A floating-point vector.

## Examples {#id_gwk_gxr_zbc}

``` {#codeblock_mnt_gxr_zbc}
def linspace(start, end, num, endpoint=true){
	if(endpoint) return end$DOUBLE\(num-1), start + end$DOUBLE\(num-1)*0..(num-1)
	else return start + end$DOUBLE\(num-1)*0..(num-1)	
}
X = linspace(0.0, 1.0, 10)[1]
Y = [0.41703981, 0.80028691, 0.12593987, 0.58373723, 0.77572962, 0.41156172, 0.72300284, 0.32559528, 0.21812564, 0.41776427]
// Fit a continuous piecewise linear function
model = piecewiseLinFit(X, Y, 3)
// Pass x locations
xHat = linspace(0.0, 1.0, 20)[1]
// Evaluate xHat using the model
pwlfPredict(model, xHat)

// output: [0.593305499919518 0.524360777381737 0.455416054843957 0.386471332306177 0.317526609768396 0.368043438179296 0.529813781212159 0.691584124245021 0.69295837868457  0.655502915538459 0.618047452392347 0.580591989246236 0.543136526100125 0.505681062954014 0.468225599807903 0.430770136661792 0.393314673515681 0.35585921036957  0.318403747223459 0.280948284077348]
```

**Related function**: [piecewiseLinFit](piecewiseLinFit.md)

