# prevState {#prevstate}

## Syntax {#syntax}

`prevState(X)`

## Arguments {#arguments}

**X** is a vector or matrix of temporal/Boolean/numeric type.

## Details {#details}

Consecutive elements in *X* with the same value feature the same state, and a null value has no state. The state of each element refers to its value. Return the previous state of the current element. If it is null, return the previous adjacent state.

If *X* is a matrix, return the previous state for each column of the matrix.

## Examples {#examples}

```
X = [1, 2.2, NULL, 2.2, 2.3, 1, 1.2]
prev(X)
// output: [,1,2.2,,2.2,2.3,1]

prevState(X)
// output: [,1,2.2,2.2,2.2,2.3,1]

X = matrix([1.0, 1.1, 1.0, 0.9], [NULL, 1.3, 2.5, 5.5], [5.5, 4.2, 1.6, 1.8])
prevState(X)
```

|\#0|\#1|\#2|
|---|---|---|
||||
|1||5.5|
|1.1|1.3|4.2|
|1|2.5|1.6|

Related function: [nextState](../n/nextState.md)

