# prev {#prev}

## Syntax {#syntax}

`prev(X)`

## Arguments {#arguments}

**X** is a vector/matrix/table.

## Details {#details}

Shift the elements of a vector to the right for one position. In comparison, [next](../n/next.md) shifts the elements of a vector to the left for one position; [move](../m/move.md) shifts the elements of a vector for multiple positions.

## Examples {#examples}

```
x=3 9 5 1 4;
prev(x);
// output: [,3,9,5,1]
```

``` {#codeblock_lb4_y1h_kfc}
x = matrix(1 2 3 4 5);
prev(x)#0
```

|\#0|
|---|
||
|1|
|2|
|3|
|4|

``` {#codeblock_xdd_1bh_kfc}
t=table(1 2 3 as a, `x`y`z as b, 10.8 7.6 3.5 as c);
prev(t)
```

|a|b|c|
|---|---|---|
||||
|1|x|10.8|
|2|y|7.6|

