# predict {#predict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`predict(model, X)`

## Arguments {#arguments}

**model** is a dictionary of the specifications of a prediction model. It is generated by functions such as [randomForestClassifier](../r/randomForestClassifier.md) or [randomForestRegressor](../r/randomForestRegressor.md).

**X** is a table. The column names must be the same as the column names in the table used to train the prediction model.

## Details {#details}

Make a prediction with the specified prediction model and data. The result is a vector with the same number of elements as the the number of rows in *X*. Each element of the vector corresponds to the predicted value of a row in *X*.

## Examples {#examples}

The following example uses the model generated by randomForestRegressor for prediction.

```
x1 = rand(100.0, 100)
x2 = rand(100.0, 100)
b0 = 6
b1 = 1
b2 = -2
err = norm(0, 10, 100)
y = b0 + b1 * x1 + b2 * x2 + err
t = table(x1, x2, y)
model = randomForestRegressor(sqlDS(<select * from t>), `y, `x1`x2)
yhat = predict(model, t);
// output: [-93.733842,2.213932,5.39619,-47.817339,-38.655786,-75.772237,-45.817417,43.412841,-87.333214,-51.275368,32.41792,-45.797275,-152.075001,-83.423919,-21.154954,-65.734012,58.088571,-30.00795,-149.71085,-18.699006,-82.023643,-140.455355,-43.629218,65.832865,-79.411508,-65.625276,-17.466925,-43.469005,44.639384,31.686378...]

plot(y, yhat, ,SCATTER);
```

![](../../images/predict01.png)

