# pow {#pow}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`pow(X, Y)`

Alias: `power`

## Arguments {#arguments}

**X** and **Y** is a scalar/vector/matrix.

## Details {#details}

Raise all elements of *X* to the power of *Y*.

Please note that the data type of the result is always DOUBLE, even if both *X* and *Y* are integers.

## Examples {#examples}

```
x=1 2 3;
pow(x,3);
// output: [1,8,27]

pow(3,x);
// output: [3,9,27]

y=4.5 5.5 6.5;
pow(x,y);
// output: [1,45.254834,1262.665039]

pow(y,x);
// output: [4.5,30.25,274.625]
```

```
m=1..10$2:5;
m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|5|7|9|
|2|4|6|8|10|

```
typestr(pow(3,4));
// output: DOUBLE
```

