# polyPredict {#polyPredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`polyPredict(model, X)`

Alias: `poly1d`

## Arguments {#arguments}

**model** is a numeric vector indicating the polynomial coefficients in ascending powers. It must not contain null values.

**X** is a numeric scalar or vector indicating the independent variable. It must not contain null values.

## Details {#details}

Calculate the value of the dependent variable for a one-dimensional polynomial based on the given coefficients and independent variable.

Return value: A numeric vector of the same length as *X*.

## Examples {#examples}

For a third-degree polynomial `2x^3+3x^2+4x+5` with coefficients \[5,4,3,2\] in ascending powers, the value of the dependent variable can be calculated:

``` {#codeblock_fw5_gg3_zzb}
model = [5,4,3,2]
x = [2.0,5.0,3.0,3.0,4.0,5.0]
y = poly1d(model,x)
y
//output: [41,350,98,98,197,350]
```

With the model and y in the above example, the coefficients can be calculated with `polyFit`:

``` {#codeblock_vpr_3g3_zzb}
polyFit(x,y,3)
// output: [5,4,3,2]
```

Related function: [polyFit](polyFit.md)

