# polyFit {#polyfit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`polyFit(X, Y, n, mode)`

## Arguments {#arguments}

**X**is a numeric vector specifying the query points. The points in *X*correspond to the fitted function values contained in *Y*.

**Y** is a numeric vector of the same length as X, which specifies the fitted values at query points. It must not contain null values.

**n** is a non-negative scalar indicating the degree of polynomial fit.

**mode** is a Boolean scalar indicating whether to return a dictionary of a vector. Defaults to 0, meaning to return a vector.

## Details {#details}

Return a vector indicating the least-squares fit polynomial coefficients in ascending powers for a polynomial `p(X)` of degree *n* that is a best fit \(in a least-squares sense\) for the data in *Y*.

## Examples {#examples}

``` {#codeblock_h3j_1g3_zzb}
x = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0]
y = [0.0, 0.8, 0.9, 0.1, -0.8, -1.0]
z = polyFit(x, y, 3)
z
// output: [-0.0397,1.6931,-0.8135,0.087]

z = polyFit(x, y, 3, 1)
/*output: 
modelName->polyFit
z->[-0.039682539682536,1.693121693121692,-0.813492063492063,0.087037037037037]
predict->polyPredict
*/
```

Related Function: [polyPredict](polyPredict.md)

