# ploadText {#ploadtext}

## Syntax {#syntax}

`ploadText(filename, [delimiter], [schema], [skipRows=0], [arrayDelimiter], [containHeader], [arrayMarker])`

## Arguments {#arguments}

Please refer to function [loadText](../l/loadText.md).

## Details {#details}

Load a text data file in parallel as an in-memory partitioned table. When the file is greater than 16 MB, it returns a in-memory table with sequential partitions. A regular in-memory table is returned otherwise.

**Note:**

-   The partitioned table returned by `ploadText` distributes data evenly across all partitions. Each partition holds between 8-16 MB of data.
-   `ploadText` is faster than `loadText` with concurrent data loading.
-   From version 1.30.22/2.00.10 onwards, `ploadText` supports loading a data file that contains a record with multiple newlines.

## Examples {#examples}

```
n=1000000
timestamp=09:30:00+rand(18000,n)
ID=rand(100,n)
qty=100*(1+rand(100,n))
price=5.0+rand(100.0,n)
t1 = table(timestamp,ID,qty,price)
saveText(t1, "C:/DolphinDB/Data/t1.txt");

timer tt1=loadText("C:/DolphinDB/Data/t1.txt");
// Time elapsed: 437.236 ms

timer tt2=ploadText("C:/DolphinDB/Data/t1.txt");
// Time elapsed: 241.126 ms

typestr(tt2);
// SEGMENTED IN-MEMORY TABLE
```

For more examples please refer to [loadText](../l/loadText.md).

