# percentile {#percentile}

## Syntax {#syntax}

`percentile(X, percent, [interpolation='linear'])`

## Arguments {#arguments}

**X** is a vector, a matrix or a table.

**percent** is an integer or a floating number between 0 and 100.

**interpolation** is a string indicating the interpolation method to use if the specified percentile is between two elements in *X* \(assuming the ith and \(i+1\)th element in the sorted *X*\) . It can take the following values:

-   'linear': Return ![](../../images/linear.png), where ![](../../images/fraction.png)

-   'lower': Return ![](../../images/xi.png)

-   'higher': Return ![](../../images/higher.png)

-   'nearest': Return ![](../../images/xi.png) or ![](../../images/higher.png) that is closest to the specified percentile

-   'midpoint': Return ![](../../images/midpoint.png)


The default value of interpolation is 'linear'.

## Details {#details}

If *X* is a vector, return the given percentile of *X*. The calculation ignores null values.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a vector

If *X* is a table, conduct the aforementioned calculation within each column of *X*. The result is a table.

## Examples {#examples}

```
a=[6, 47, 49, 15, 42, 41, 7, 39, 43, 40, 36];

percentile(a,50);
// output: 40

percentile(a,54);
// output: 40.4

percentile(a,25,"lower");
// output: 15

percentile(a,75,"higher");
// output: 43

percentile(a,5,"midpoint");
// output: 6.5

percentile(a,5,"nearest");
// output: 6
```

```
m=matrix(1 2 5 3 4, 5 4 1 2 3);
m;
```

|\#0|\#1|
|---|---|
|1|5|
|2|4|
|5|1|
|3|2|
|4|3|

```
percentile(m, 75);
// output: [4,4]
```

Related function: [quantile](../q/quantile.md)

