# parseInteger {#parseInteger}

## Syntax {#Syntax .section}

`parseInteger(X, type, [radix=10])`

Alias: `parseInt`

## Arguments {#Arguments .section}

**X** is a STRING scalar, vector, pair or matrix.

**type** specifies the data type of the integer, which can be CHAR, SHORT, INT or LONG.

**radix** \(optional\) is an integer in \[2, 16\] that represents the radix \(the base in mathematical numeral systems\) of the integer. The default value is 10.

-   For *radix* 2, only '0' and '1' are allowed.
-   For *radix* 11-16, 'A'/'a' to 'F'/'f' \(case insensitive\) are used for 10-15.
-   Specifically for *radix* 16, leading '0x' or '0X' is allowed.

## Details {#Details .section}

`parseInteger` parses *X* into an integer of the specified *type* in specified *radix*. If it encounters a character that is not a numeral in the specified *radix*, it ignores it and all succeeding characters and returns the integer value parsed up to that point. An exception will be thrown if the first character is invalid.

**Return value**: A CHAR/SHORT/INT/LONG scalar/vector/pair/matrix of the same shape as *X*.

**Note:**

-   Leading whitespaces or zeros are ignored during parsing.
-   Decimal values are not supported, i.e., the point `.` is considered illegal.
-   An empty string is parsed as null.
-   The sign character `+/-` indicates positive or negative only if it appears after a leading whitespace, otherwise it is considered illegal.

## Examples {#Examples .section}

``` {#codeblock_am5_qyw_nbc}
parseInteger([" ", "000", "012", " 12","12a", "1a2","+12a", "-12"], INT)
//output: [ , 0, 12, 12, 12, 1, 12, -12]

parseInteger("a12", INT)
//Error: 'Invalid string to parse.'

parseInteger(["012", " 12","12a", "1a2","1A2", "-1A2"], INT, 11)
//output: [13, 13, 153, 233, 233, -233]

parseInteger("0X16", INT)
//output:0

parseInteger(["0x16", "3F"], INT, 16)
//output:[22, 63]

parseInteger( "9" , INT, 8)
//Error: 'Invalid string to parse.'
```



**Parent topic:**[Functions](../../Functions/category.md)

