# parseInstrument {#parseInstrument}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`parseInstrument(obj)`

## Arguments {#arguments}

**obj** is a dictionary or a tuple of dictionaries indicating the instrument description to be parsed.

## Details {#details}

Parse the instrument description *obj* into an INSTRUMENT object for modeling and pricing. See Supported Instruments and Fields for details.

Note: `parseInstrument` preserves non-standard scalar or vector fields \(i.e., fields not defined as attributes of the financial instrument\) during serialization or deserialization.

**Return value**: An INSTRUMENT object.

## Supported Instruments and Fields {#topic_hkm_pwl_ngc}

The INSTRUMENT type is newly introduced in DolphinDB version 3.00.4, designed to store financial instruments and provide a foundation for pricing and risk measurement of financial products.

The `parseInstrument` function generates corresponding instrument objects based on the fields of the instrument description. Currently, only instrument types illustrated as leaf nodes in the classification tree below are supported:

![](../images/parseInstrument.png)

### Discount Bond \(DiscountBond\) {#topic_crk_swl_ngc}

<table id="table_lhn_twl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "DiscountBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

issuePrice

</td><td>

DOUBLE

</td><td>

Issue price

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of DiscountBond type.

``` {#codeblock_rhn_twl_ngc}
bond = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "DiscountBond",
    "version": 0, 
    "instrumentId": "259924.IB",
    "start": 2025.04.17,
    "maturity": 2025.07.17,
    "issuePrice": 99.664,
    "dayCountConvention": "ActualActualISDA"
}
instrument = parseInstrument(bond)
print(instrument)
```

### Zero Coupon Bond \(ZeroCouponBond\) {#topic_wmv_vwl_ngc}

<table id="table_ijm_xwl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "ZeroCouponBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

coupon

</td><td>

DOUBLE

</td><td>

Coupon rate, e.g., 0.03 means 3%

</td><td>

√

</td></tr><tr><td>

frequency

</td><td>

STRING

</td><td>

Frequency of interest payment

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of ZeroCouponBond type.

``` {#codeblock_ojm_xwl_ngc}
dict = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "ZeroCouponBond",
    "version": 0, 
    "instrumentId": "250401.IB",
    "start": 2025.01.09,
    "maturity": 2026.02.05,
    "coupon": 0.0119,
    "dayCountConvention": "ActualActualISDA"
}
```

### Fixed Rate Bond \(FixedRateBond\) {#topic_atl_zwl_ngc}

<table id="table_atl_1xl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "FixedRateBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

coupon

</td><td>

DOUBLE

</td><td>

Coupon rate, e.g., 0.03 means 3%

</td><td>

√

</td></tr><tr><td>

frequency

</td><td>

STRING

</td><td>

Frequency of interest payment

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of FixedRateBond type.

``` {#codeblock_gtl_1xl_ngc}
bond = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "FixedRateBond",
    "version": 0, 
    "instrumentId": "240021.IB",
    "start": 2024.10.25,
    "maturity": 2025.10.25,
    "issuePrice": 100,
    "coupon": 0.0133,
    "frequency": "Annual",
    "dayCountConvention": "ActualActualISDA"
}
instrument = parseInstrument(bond)
print(instrument)
```

### Bond Futures \(BondFutures\) {#topic_lvk_cxl_ngc}

|Field Name|Data Type|Description|Required|
|----------|---------|-----------|--------|
|productType|STRING|Must be "Futures"|√|
|futuresType|STRING|Must be "BondFutures"|√|
|version|INT|Version, default 0|×|
|nominal|DOUBLE|Nominal amount, defalut 100|×|
|instrumentId|STRING|Bond future code, e.g., "T2509"|×|
|maturity|DATE|Maturity date|√|
|settlement|DATE|Settlement date|√|
|underlying|Dictionary|Fixed-rate bond structure, indicating the underlying deliverable bonds.|√|
|nominalCouponRate|DOUBLE|Mominal coupon rate|√|

Define an INSTRUMENT object of BondFutures type.

``` {#codeblock_xqh_dxl_ngc}
bond ={
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "FixedRateBond",
    "version": 0, 
    "instrumentId": "220010.IB",
    "start": 2020.12.25,
    "maturity": 2031.12.25,
    "issuePrice": 100.0,
    "coupon": 0.0149,
    "frequency": "Annual",
    "dayCountConvention": "ActualActualISDA"
}

futures =  {
    "productType": "Futures",
    "futuresType": "BondFutures",
    "version": 0,
    "instrumentId": "T2509",  //Future code
    "nominal": 100.0,
    "maturity": "2022.09.09",
    "settlement": "2022.09.11",
    "underlying": bond,
    "nominalCouponRate": 0.03  //Nominal coupon rate corresponding to the bond futures. You can get it from the China Financial Futures Exchange (CFFEX).
}
instrument = parseInstrument(futures)
print(instrument)
```

### Deposit \(Deposit\) {#topic_qrk_fxl_ngc}

|Field Name|Data Type|Description|Required|
|----------|---------|-----------|--------|
|productType|STRING|Must be "Cash"|√|
|assetType|STRING|Must be "Deposit"|√|
|version|INT|Version, default 0|√|
|notional|ANY vector|Notional principal amount, e.g., \["USD", 1.0\]|√|
|instrumentId|STRING|Deposit reference rate index, e.g., "SHIBOR\_3M"|×|
|start|DATE|Value date|√|
|maturity|DATE|Maturity date|√|
|rate|DOUBLE|Deposit interest rate|√|
|dayCountConvention|STRING|The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"|√|
|payReceive|STRING|Pay/Receive indicator: "Pay" indicates paying; "Receive" indicates receiving.|√|
|domesticCurve|STRING|The domestic discount curve. The default is "CNY\_FR\_007" for CNY.|×|
|calendar|STRING|Trading calendar|×|

Define an INSTRUMENT object of Deposit type.

``` {#codeblock_a4h_gxl_ngc}
deposit =  {
    "productType": "Cash",
    "assetType": "Deposit",
    "version": 0, 
    "start": 2025.05.15,
    "maturity": 2025.08.15,
    "rate": 0.02,
    "dayCountConvention": "Actual360",
    "notional":["CNY", 1E6],
    "payReceive": "Receive"
}
instrument = parseInstrument(deposit)
print(instrument)
```

### IR Fixed-Floating Swap \(IrFixedFloatingSwap\) {#topic_hqh_3xl_ngc}

<table id="table_fkl_jxl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Swap"

</td><td>

√

</td></tr><tr><td>

swapType

</td><td>

STRING

</td><td>

Must be "IrSwap"

</td><td>

√

</td></tr><tr><td>

irSwapType

</td><td>

STRING

</td><td>

Must be "IrFixedFloatingSwap"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

notional

</td><td>

ANY vector

</td><td>

Notional principal amount, e.g., \["USD", 1.0\]

</td><td>

√

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

IR fixed-floating swap name. It can be "CNY\_FR\_007 or "CNY\_SHIBOR\_3M".

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

fixedRate

</td><td>

DOUBLE

</td><td>

Fixed-rate

</td><td>

√

</td></tr><tr><td>

calender

</td><td>

STRING

</td><td>

Trading calendar

</td><td>

√

</td></tr><tr><td>

fixedDayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

floatingDayCountConvetion

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

spread

</td><td>

DOUBLE

</td><td>

Interest rate spread

</td><td>

√

</td></tr><tr><td>

iborIndex

</td><td>

STRING

</td><td>

Floating reference rate. It can be "FR\_007" or "SHIBOR\_3M".

</td><td>

√

</td></tr><tr><td>

frequency

</td><td>

STRING

</td><td>

Frequency of interest payment

</td><td>

√

</td></tr><tr><td>

payReceive

</td><td>

STRING

</td><td>

Pay/Receive indicator

 -   "Pay": pay fixed interest rate/ receive floating interest rate

-   "Receive": receive fixed interest rate/ pay floating interest rate


</td><td>

√

</td></tr><tr><td>

domesticCurve

</td><td>

STRING

</td><td>

The domestic discount curve name

</td><td>

×

</td></tr><tr><td>

foreignCurve

</td><td>

STRING

</td><td>

The foreign discount curve name

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of IrFixedFloatingSwap type.

``` {#codeblock_lkl_jxl_ngc}
swap =  {
    "productType": "Swap",
    "swapType": "IrSwap",
    "irSwapType": "IrFixedFloatingSwap",
    "version": 0, 
    "start": 2021.05.15,
    "maturity": 2023.05.15,
    "frequency": "Quarterly",
    "fixedRate": 0.02,
    "calendar": "CFET", 
    "fixedDayCountConvention": "Actual365",
    "floatingDayCountConvention": "Actual360",
    "payReceive": "Pay",
    "iborIndex": "SHIBOR_3M",
    "spread": 0.0005,
    "notional":["CNY", 1E8]
}
instrument = parseInstrument(swap)
print(instrument)
```

### Foreign Exchange Forward \(FxForward\) {#topic_lqj_lxl_ngc}

<table id="table_snc_mxl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Product name. It must be "Forward".

</td><td>

√

</td></tr><tr><td>

forwardType

</td><td>

STRING

</td><td>

Foreign exchange forward type. It must be "FxForward".

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

notional

</td><td>

ANY vector

</td><td>

Notional principal amount, e.g., \["USD", 1.0\]

</td><td>

√

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

InstrumentId ID

</td><td>

×

</td></tr><tr><td>

expiry

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

delivery

</td><td>

DATE

</td><td>

Settlement date

</td><td>

√

</td></tr><tr><td>

currencyPair

</td><td>

STRING

</td><td>

The currency pair, in the format "EURUSD", "EUR.USD", or "EUR/USD". Supported currency pairs include:

 -   "EURUSD": Euro to US Dollar

-   "USDCNY": US Dollar to Chinese Yuan

-   "EURCNY": Euro to Chinese Yuan

-   "GBPCNY": British Pound to Chinese Yuan

-   "JPYCNY": Japanese Yen to Chinese Yuan

-   "HKDCNY": Hong Kong Dollar to Chinese Yuan


</td><td>

√

</td></tr><tr><td>

direction

</td><td>

STRING

</td><td>

Trading direction, can be "Buy" or "Sell"

</td><td>

√

</td></tr><tr><td>

strike

</td><td>

DOUBLE

</td><td>

Strike price

</td><td>

√

</td></tr><tr><td>

domesticCurve

</td><td>

STRING

</td><td>

The domestic discount curve name

</td><td>

×

</td></tr><tr><td>

foreignCurve

</td><td>

STRING

</td><td>

The foreign discount curve name

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of FxForward type.

``` {#codeblock_ync_mxl_ngc}
forward =  {
   "productType": "Forward",
    "forwardType": "FxForward",
    "version": 0,
    "expiry": 2025.09.24,
    "delivery": 2025.09.26,
    "currencyPair": "USDCNY",
    "direction": "Buy",
    "notional": ["USD", 1E8],
    "strike": 7.2
}
instrument = parseInstrument(forward)
print(instrument)
```

### Foreign Exchange Swap \(FxSwap\) {#topic_wcx_nxl_ngc}

<table id="table_fz5_4xl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Product name. It must be "Swap".

</td><td>

√

</td></tr><tr><td>

swapType

</td><td>

STRING

</td><td>

Foreign exchange swap type. It must be "FxSwap".

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

notional

</td><td>

ANY vector

</td><td>

Notional principal amount, e.g., \["USD", 1.0\]

</td><td>

√

</td></tr><tr><td>

currencyPair

</td><td>

STRING

</td><td>

The currency pair, in the format "EURUSD", "EUR.USD", or "EUR/USD". Supported currency pairs include:

 -   "EURUSD": Euro to US Dollar

-   "USDCNY": US Dollar to Chinese Yuan

-   "EURCNY": Euro to Chinese Yuan

-   "GBPCNY": British Pound to Chinese Yuan

-   "JPYCNY": Japanese Yen to Chinese Yuan

-   "HKDCNY": Hong Kong Dollar to Chinese Yuan


</td><td>

√

</td></tr><tr><td>

nearExpiry

</td><td>

DATE

</td><td>

Maturity date for the near leg

</td><td>

√

</td></tr><tr><td>

nearDelivery

</td><td>

DATE

</td><td>

Settlement date for the near leg

</td><td>

√

</td></tr><tr><td>

direction

</td><td>

STRING

</td><td>

Trading direction, can be

 -   "Buy": Buy the foreign currency on the near leg and sell it on the far leg.

-   "Sell": Sell the foreign currency on the near leg and buy it back on the far leg.


</td><td>

√

</td></tr><tr><td>

nearStrike

</td><td>

DOUBLE

</td><td>

Strike price for the near leg

</td><td>

√

</td></tr><tr><td>

farExpiry

</td><td>

DATE

</td><td>

Maturity date for the far leg

</td><td>

√

</td></tr><tr><td>

farDelivery

</td><td>

DATE

</td><td>

Settlement date for the far leg

</td><td>

√

</td></tr><tr><td>

farStrike

</td><td>

DOUBLE

</td><td>

Strike price for the far leg

</td><td>

√

</td></tr><tr><td>

domesticCurve

</td><td>

STRING

</td><td>

The domestic discount curve name

</td><td>

×

</td></tr><tr><td>

foreignCurve

</td><td>

STRING

</td><td>

The foreign discount curve name

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of FxSwap type.

``` {#codeblock_mz5_4xl_ngc}
swap = {
    "productType": "Swap",
    "swapType": "FxSwap",
    "version": 0,
    "currencyPair": "EURUSD",
    "direction": "Buy",
    "notional": ["EUR", 1E6],
    "nearStrike": 1.1,
    "nearExpiry": 2025.12.08,
    "nearDelivery": 2025.12.10,
    "farStrike": 1.2,
    "farExpiry": 2026.06.08,
    "farDelivery": 2026.06.10
}
instrument = parseInstrument(swap)
print(instrument)
```

### Fx European Style Option \(FxEuropeanOption\) {#topic_kjh_qxl_ngc}

<table id="table_pmm_rxl_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Option"

</td><td>

√

</td></tr><tr><td>

optionType

</td><td>

STRING

</td><td>

Must be "EuropeanOpiton"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "FxEuropeanOpiton"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

notional

</td><td>

ANY vector

</td><td>

Notional principal amount, e.g., \["USD", 1.0\]

</td><td>

√

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

InstrumentId ID

</td><td>

×

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

underlying

</td><td>

STRING

</td><td>

The currency pair, in the format "EURUSD", "EUR.USD", or "EUR/USD". Supported currency pairs include:

 -   "EURUSD": Euro to US Dollar

-   "USDCNY": US Dollar to Chinese Yuan

-   "EURCNY": Euro to Chinese Yuan

-   "GBPCNY": British Pound to Chinese Yuan

-   "JPYCNY": Japanese Yen to Chinese Yuan

-   "HKDCNY": Hong Kong Dollar to Chinese Yuan


</td><td>

√

</td></tr><tr><td>

direction

</td><td>

STRING

</td><td>

Trading direction, can be "Buy" or "Sell"

</td><td>

√

</td></tr><tr><td>

strike

</td><td>

DOUBLE

</td><td>

Strike price

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

payoffType

</td><td>

STRING

</td><td>

Payoff type. It can be "Call" or "Put".

</td><td>

√

</td></tr><tr><td>

domesticCurve

</td><td>

STRING

</td><td>

The domestic discount curve name

</td><td>

×

</td></tr><tr><td>

foreignCurve

</td><td>

STRING

</td><td>

The foreign discount curve name

</td><td>

×

</td></tr></tbody>
</table>Define an INSTRUMENT object of FxEuropeanOption type.

``` {#codeblock_vmm_rxl_ngc}
option =  {
    "productType": "Option",
    "optionType": "EuropeanOption",
    "assetType": "FxEuropeanOption",
    "version": 0,
    "notional": ["EUR", 1000000.0],
    "strike": 1.2,
    "maturity": "2025.10.08",
    "payoffType": "Call",
    "dayCountConvention": "Actual365",
    "underlying": "EURUSD"
}
instrument = parseInstrument(option)
print(instrument)
```

**Related functions:** [bondPricer](../b/bondPricer.md) \(Bond Pricing\), [irDepositPricer](../i/irDepositPricer.md) \(Deposit Pricing\), [bondFuturesPricer](../b/bondFuturesPricer.md) \(Treasury Futures Pricing\), [fxForwardPricer](../f/fxForwardPricer.md) \(FX Forward Pricing\), [fxSwapPricer](../f/fxSwapPricer.md) \(FX Swap Pricing\), [irFixedFloatingSwapPricer](../i/irFixedFloatingSwapPricer.md) \(IR Fixed-Floating Swap Pricing\), [fxEuropeanOptionPricer](../f/fxEuropeanOptionPricer.md) \(FX European Option Pricing\)

