# optionVolPredict {#optionVolPredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`optionVolPredict(volsurf, dt, strike)`

## Details {#topic_tlc_v2r_ngc}

Predict the volatility at a given point based on its time and strike price from the specified volatility surface.

**Return value**: A DOUBLE matrix with the shape size\(dt\) \* size\(strike\). Rows are the input *dt,* and columns are the input *strike*.

## Arguments {#arguments}

**volsurf** is a MKTDATA object of VolatilitySurface type.

**dt** is a DOUBLE scalar/vector or a DATE scalar/vector.

-   A DOUBLE scalar/vector indicates time in years.

-   A DATE scalar/vector indicates specific date\(s\).


**strike** is a DOUBLE scalar/vector indicating the strike price\(s\).

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
refDate = 2025.08.18
ccyPair = "USDCNY"
quoteTerms = ['1d', '1w', '2w', '3w', '1M', '2M', '3M', '6M', '9M', '1y', '18M', '2y', '3y']
quoteNames = ["ATM", "D25_RR", "D25_BF", "D10_RR", "D10_BF"]
quotes = [0.030000, -0.007500, 0.003500, -0.010000, 0.005500, 
          0.020833, -0.004500, 0.002000, -0.006000, 0.003800, 
          0.022000, -0.003500, 0.002000, -0.004500, 0.004100, 
          0.022350, -0.003500, 0.002000, -0.004500, 0.004150, 
          0.024178, -0.003000, 0.002200, -0.004750, 0.005500, 
          0.027484, -0.002650, 0.002220, -0.004000, 0.005650, 
          0.030479, -0.002500, 0.002400, -0.003500, 0.005750, 
          0.035752, -0.000500, 0.002750,  0.000000, 0.006950, 
          0.038108,  0.001000, 0.002800,  0.003000, 0.007550, 
          0.039492,  0.002250, 0.002950,  0.005000, 0.007550, 
          0.040500,  0.004000, 0.003100,  0.007000, 0.007850, 
          0.041750,  0.005250, 0.003350,  0.008000, 0.008400, 
          0.044750,  0.006250, 0.003400,  0.009000, 0.008550]

quotes = reshape(quotes, size(quoteNames):size(quoteTerms)).transpose()

spot = 7.1627
curveDates = [2025.08.21,
              2025.08.27,
              2025.09.03,
              2025.09.10,
              2025.09.22,
              2025.10.20,
              2025.11.20,
              2026.02.24,
              2026.05.20,
              2026.08.20,
              2027.02.22,
              2027.08.20,
              2028.08.21]

domesticCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": refDate,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[1.5113, 
              1.5402, 
              1.5660, 
              1.5574, 
              1.5556, 
              1.5655, 
              1.5703, 
              1.5934, 
              1.6040, 
              1.6020, 
              1.5928, 
              1.5842, 
              1.6068]/100
}
foreignCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": refDate,
    "currency": "USD",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[4.3345, 
              4.3801, 
              4.3119, 
              4.3065, 
              4.2922, 
              4.2196, 
              4.1599, 
              4.0443, 
              4.0244, 
              3.9698, 
              3.7740, 
              3.6289, 
              3.5003]/100
}

domesticCurve = parseMktData(domesticCurveInfo)
foreignCurve = parseMktData(foreignCurveInfo)

surf = fxVolatilitySurfaceBuilder(refDate, ccyPair, quoteNames, quoteTerms, quotes, spot, domesticCurve, foreignCurve)

optionVolPredict(surf, 2025.10.18, 7)
```

||7|
|---|---|
|2025.10.18|0.035427|

``` {#codeblock_ms3_1fr_ngc}
optionVolPredict(surf, 2025.10.18, [7.1,7.2])
```

||7.1|7.2|
|---|---|---|
|2025.10.18|0.02946679951336248|0.02926808425498284|

``` {#codeblock_hrn_y2r_ngc}
optionVolPredict(surf, [2025.10.18, 2026.10.18], 7)
```

<table id="table_irn_y2r_ngc"><tbody><tr><td>



</td><td>

7

</td></tr><tr><td>

2025.10.18

</td><td>

0.03542772267328074

</td></tr><tr><td>

2026.10.18

</td><td>

0.04045352876306188

</td></tr></tbody>
</table>``` {#codeblock_lrn_y2r_ngc}
optionVolPredict(surf, [2025.10.18, 2026.10.18], [7.1, 7.2])
```

||7.1|7.2|
|---|---|---|
|2025.10.18|0.02946679951336248|0.02926808425498284|
|2026.10.18|0.04218869392416815|0.04440856375512336|

**Related function:**[parseMktData](../p/parseMktData.md)

