# oneHot {#onehot}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`oneHot(obj, encodingColumns)`

## Arguments {#arguments}

**obj** is an in-memory table.

**encodingColumns** is a STRING scalar or vector, indicating the columns for one-hot encoding.

## Details {#details}

Perform one-hot encoding on the specified columns in an in-memory table. It returns a table with columns in the order of encoded columns and non-encoded columns. The name of the encoded columns is "original column name\_value".

## Examples {#examples}

```
t = table( take(`Tom`Lily`Jim, 10) as name, take(true false, 10) as gender, take(21..23,10) as age);
oneHot(t, `name`gender);
```

|name\_Tom|name\_Lily|name\_Jim|gender\_1|gender\_0|age|
|---------|----------|---------|---------|---------|---|
|1|0|0|1|0|21|
|0|1|0|0|1|22|
|0|0|1|1|0|23|
|1|0|0|0|1|21|
|0|1|0|1|0|22|
|0|0|1|0|1|23|
|1|0|0|1|0|21|
|0|1|0|0|1|22|
|0|0|1|1|0|23|
|1|0|0|0|1|21|

