# objectType {#objectType}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`objectType(obj)`

## Arguments {#arguments}

**obj** can be of any data type.

## Details {#details}

-   If *obj* is not of type CODE, the function returns "CONSTOBJ".
-   If *obj* is of type CODE, the function returns the type of the object represented by *obj*. Possible return values include:

|Value|Description|
|-----|-----------|
|CONSTOBJ|Constant|
|VAR|Variable|
|GLOBAL|Global object|
|ATTR|Attribute of an object|
|DIM|Dimension|
|TUPLE|Tuple|
|FUNCTION|Function|
|EXPRESSION|Expression|
|COLUMN|Column|
|COLUMNDEF|Column definition|
|SQLQUERY|SQL query|
|TABLEJOINER|Table join|
|VIRTUALCONST|Virtual constant|
|MAPPEDCOL|Mapped column|
|GLOBALTALBE|Global table|
|GROUPTASK|Group of tasks|
|DIMTABLE|Dimension table|
|METHODCALL|Method call on an object|
|SQLUPDATE|SQL update statement|
|SQLDELETE|SQL delete statement|
|COLSELECTOR|Column selector|
|CASEWHEN|SQL conditional expression|
|SQLEXISTS|SQL existence check|
|SQLWITHQUERY|SQL common table expression|
|OPTOBJ|Optimized object|
|MULTITABLEJOINER|Multi-table join|
|UNKNOWN|Unknown \(not matching any of the above\)|

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
objectType(<select * from pt>)
// output: SQLQUERY

objectType(sqlColAlias(<col1>,`col))
// output: COLUMNDEF

objectType(<x+y>)
// output: EXPRESSION
```

