# nssPredict {#nssPredict}

## Syntax {#Syntax.1 .section}

`nssPredict(model, T)`

## Arguments {#Arguments.1 .section}

**model** is a dictionary with the following key-value pairs:

-   modelName: A string "ns" \(Nelson-Siegel\) or "nss" \(Nelson-Siegel-Svensson\).

-   params: A numeric vector indicating the fitted model parameters.

    -   NS model: a vector of length 4, containing β0, β1, β2, λ.

    -   NSS model: a vector of length 6, containing β0, β1, β2, β3, λ0, λ1.


**T** is a numeric vector with positive elements, indicating the maturity \(in years\) of a bond.



## Details {#Details.1 .section}

Predict yield using the NS/NSS model.



**Examples**

``` {#codeblock_wjj_cjc_gbc}
model = dict(STRING, ANY)
model[`modelName] = `nss
model[`params] = [0.038184469794996,-0.048575389082029,-0.022287414169806,0.047523360012739,1.873046195772644,0.161159907274023]
T = [3,1]
nssPredict(model, T)
//output: [0.009904201306,0.003891991292041]
```

**Parent topic:**[Functions](../../Functions/category.md)

