# nss {#nss}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_iln_cgs_cdc}

`nss(maturity, yield, [method='nm'], [maxIter], [bounds], [initialGuess], [seed])`

## Arguments {#arguments}

**maturity** is a numeric vector with non-negative elements, indicating the maturity \(in years\) of a bond.

**yield** is a numeric vector of the same length as *maturity*, indicating the bond yield.

**method** \(optional\) is a string indicating the model used. It can be:

-   'nm' \(default\): Nelder-Mead simplex algorithm.
-   'bfgs': BFGS algorithm.
-   'lbfgs': LBFGS algorithm.
-   'slsqp': Sequential Least Squares Programming algorithm.
-   'de': Differential Evolution algorithm.

**maxIter** \(optional\) is an integral scalar or vector indicating the maximum number of iterations for the optimization algorithm during the fitting process.

**bounds** \(optional\) is a numeric matrix in the shape of \(N,2\), where N is the number of parameters to be optimized. The two elements of each row defines the bounds \(min, max\) on that parameter. Note that *bounds* only takes effect when method is 'lbfgs', ‘slsqp’ or ‘de’.

**initialGuess** \(optional\) is a numeric vector indicating the initial guess for the parameters that optimize the function.

NS model: The vector contains 4 elements: initial guess of β0, β1, β2, λ, with the default value \[0.01, 0.01, 0.01, 1.0\].

NSS model: The vector contains 6 elements: initial guess of β0, β1, β2, β3, λ0, λ1, with the default value \[0.01, 0.01, 0.01, 0.01, 1.0, 1.0\].

**seed** \(optional\) is an integer indicating the random number seed used in the differential evolution algorithm to ensure the reproducibility of results. It only takes effect when *method*='de'. If not specified, a non-deterministic random number generator is used.

## Details {#topic_kln_cgs_cdc}

Fit yield curve using NSS \(Nelson-Siegel-Svensson\) model.

**Return value**: A dictionary with the following keys:

-   modelName: The model used.
-   params: The fitted model parameters.
    -   NS model: a vector of length 4, containing β0, β1, β2, λ.
    -   NSS model: a vector of length 6, containing β0, β1, β2, β3, λ0, λ1.
-   fminResult: The optimization result.
    -   'nm' : See fmin.
    -   'bfgs': See fminBFGS.
    -   'lbfgs': See fminLBFGSB.
    -   'slsqp': See fminSLSQP.
    -   'de': See differentialEvolution.
-   predict: The prediction function of the model, which returns the predicted yield with this model. It can be called using `model.predict(T)` or `predict(model, T)`, where T is the maturity in years.

## Examples {#topic_mln_cgs_cdc}

Use the bfgs method to fit yield curve based on NSS \(Nelson-Siegel-Svensson\) model.

``` {#codeblock_gh1_sjs_cdc}
maturity = [1,2,3,4,5,8,10,15,20,25,30]
yield = [0.0039,0.0061,NULL,NULL,0.0166,NULL,0.0258,NULL,NULL,0.0332,NULL]
model = nss(maturity, yield, method='bfgs');
model;

/*Output
modelName->nss
params->[0.036140551464406,-0.017389058792285,-0.039552798745696,-0.039554933812457,1.001838685848857,1.000930288743548]
fminResult->xopt->[0.036140551464406,-0.017389058792285,-0.039552798745696,-0.039554933812457,1.001838685848857,1.000930288743548]
fopt->0.000003185056025
gopt->[4.415407204305666E-7,8.382398277717584E-7,-2.683916591195157E-7,-4.651950860079524E-7,-0.000008569511408,-0.000008564345961]
iterations->10
Hinv->#0                 #1                 #2                 #3                 #4                 #5                
------------------ ------------------ ------------------ ------------------ ------------------ ------------------
0.492426526437359  0.696702464055202  -1.643864246164442 -1.644086017367336 0.08871259052824   0.037055616913674 
0.696702464055203  9.022078200827937  -9.027640937693616 -9.027654505585944 0.659730122918773  0.302144825834614 
-1.643864246164441 -9.027640937693616 12.179963755936533 11.180865226841653 -0.737531568671335 -0.323934330889313
-1.644086017367337 -9.027654505585944 11.180865226841657 12.181767428775573 -0.737537584440894 -0.32392102429678 
0.08871259052824   0.659730122918772  -0.737531568671335 -0.737537584440894 1.053013492023418  0.024560701245749 
0.037055616913674  0.302144825834614  -0.323934330889313 -0.32392102429678  0.024560701245749  1.011692492570688 

warnFlag->0
fcalls->84
gcalls->12

predict->nssPredict
*/
```

Use the nm method to fit yield curve based on NSS \(Nelson-Siegel-Svensson\) model.

``` {#codeblock_e5g_5js_cdc}
model = ns(maturity, yield, method='nm');
model;
/*Output
modelName->nss
params->[0.038184469794996,-0.048575389082029,-0.022287414169806,0.047523360012739,1.873046195772644,0.161159907274023]
fminResult->xopt->[0.038184469794996,-0.048575389082029,-0.022287414169806,0.047523360012739,1.873046195772644,0.161159907274023]
fopt->5.456415848001168E-9
iterations->541
fcalls->860
warnFlag->0

predict->nssPredict
*/
```

Related Functions: [nsspredict](nssPredict.md), [ns](ns.md)

