# ns {#ns}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ns(maturity, yield, [method='nm'], [maxIter], [bounds], [initialGuess], [seed])`

## Arguments {#arguments}

**maturity** is a numeric vector with non-negative elements, indicating the maturity \(in years\) of a bond.

**yield** is a numeric vector of the same length as *maturity*, indicating the bond yield.

**method** \(optional\) is a string indicating the model used. It can be:

-   'nm' \(default\): Nelder-Mead simplex algorithm.
-   'bfgs': BFGS algorithm.
-   'lbfgs': LBFGS algorithm.
-   'slsqp': Sequential Least Squares Programming algorithm.
-   'de': Differential Evolution algorithm.

**maxIter** \(optional\) is an integral scalar or vector indicating the maximum number of iterations for the optimization algorithm during the fitting process.

**bounds** \(optional\) is a numeric matrix in the shape of \(N,2\), where N is the number of parameters to be optimized. The two elements of each row defines the bounds \(min, max\) on that parameter. Note that *bounds* only takes effect when method is 'lbfgs', ‘slsqp’ or ‘de’.

**initialGuess** \(optional\) is a numeric vector indicating the initial guess for the parameters that optimize the function.

NS model: The vector contains 4 elements: initial guess of β0, β1, β2, λ, with the default value \[0.01, 0.01, 0.01, 1.0\].

NSS model: The vector contains 6 elements: initial guess of β0, β1, β2, β3, λ0, λ1, with the default value \[0.01, 0.01, 0.01, 0.01, 1.0, 1.0\].

**seed** \(optional\) is an integer indicating the random number seed used in the differential evolution algorithm to ensure the reproducibility of results. It only takes effect when *method*='de'. If not specified, a non-deterministic random number generator is used.

## Details {#details}

Fit yield curve using NS \(Nelson-Siegel\) model.

**Return value**: A dictionary with the following keys:

-   modelName: The model used.
-   params: The fitted model parameters.
    -   NS model: a vector of length 4, containing β0, β1, β2, λ.
    -   NSS model: a vector of length 6, containing β0, β1, β2, β3, λ0, λ1.
-   fminResult: The optimization result.
    -   'nm' : See fmin.
    -   'bfgs': See fminBFGS.
    -   'lbfgs': See fminLBFGSB.
    -   'slsqp': See fminSLSQP.
    -   'de': See differentialEvolution.
-   predict: The prediction function of the model, which returns the predicted yield with this model. It can be called using `model.predict(T)` or `predict(model, T)`, where T is the maturity in years.

## Examples {#examples}

Use the bfgs method to fit yield curve based on NS \(Nelson-Siegel\) model.

``` {#codeblock_gh1_sjs_cdc}
maturity = [1,2,3,4,5,8,10,15,20,25,30]
yield = [0.0039,0.0061,NULL,NULL,0.0166,NULL,0.0258,NULL,NULL,0.0332,NULL]
model = ns(maturity, yield, method='bfgs');
model;
/*Output
modelName->ns
params->[0.037907009765789,-0.032345632006991,-0.048221596538028,1.48711064869407]
fminResult->xopt->[0.037907009765789,-0.032345632006991,-0.048221596538028,1.48711064869407]
fopt->7.682740281926149E-8
gopt->[0.000007050477817,-0.000001557728067,8.217072418048589E-7,-7.435919702203364E-8]
iterations->29
Hinv->#0                  #1                    #2                   #3                   
------------------- --------------------- -------------------- ---------------------
1.046957491287936   -2.422265785994416    4.016547235964936    174.575362711334378  
-2.422265785994413  20.767722224747515    -55.516118469836506  -1160.911707217612729
4.016547235964929   -55.516118469836506   162.441840532431541  3127.297987855009978 
174.575362711334378 -1160.911707217613638 3127.297987855011797 72743.950482441126951

warnFlag->0
fcalls->165
gcalls->33

predict->nssPredict
*/
```

Use the nm method to fit yield curve based on NS \(Nelson-Siegel\) model.

``` {#codeblock_e5g_5js_cdc}
model = ns(maturity, yield, method='nm');
model;
/*Output
modelName->ns
modelName->ns
params->[-0.017297505365068,0.016544815374471,0.142682692134247,14.720778706012911]
fminResult->xopt->[-0.017297505365068,0.016544815374471,0.142682692134247,14.720778706012911]
fopt->0.000001443427918
iterations->446
fcalls->740
warnFlag->0

predict->nssPredict
*/
```

Related Function: [nss](nss.md)

