# not {#not}

## Syntax {#syntax}

`not(X)` or `!(X)`

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

## Details {#details}

Return NOT of each element of *X*. Returned values are 0, 1, or null. NOT of 0 is 1; NOT of null is still null; NOT of all other values is 0.

Though `not` and the `!` operator often serve analogous purposes, precedence behavior differs:

-   The `not` function, when parenthesized carries the highest priority. Without parentheses, `not` has lower precedence than the following expression, e.g., `not false and false` is equivalent to `not(false and false)`, which returns true.

-   The `!` operator always follows the precedence rule. For example: `！false and false` is equivalent to `(!false) and false`, which returns false.


## Examples {#examples}

```
!1.5;
// output: 0

not 0;
// output: 1

x=1 0 2;
not x;
// output: [0,1,0]
```

```
m=1 1 1 1 1 0 0 0 0 0$2:5;
m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|1|1|0|0|
|1|1|0|0|0|

```
not m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|0|0|0|1|1|
|0|0|1|1|1|

```
(1).not();
// output: 0

(!NULL)==NULL;
// output: 1
```

Related functions: [and](../a/and.md), [or](../../Programming/Operators/OperatorReferences/or.md)

