# next {#next}

## Syntax {#syntax}

`next(X)`

## Arguments {#arguments}

**X** is a vector/matrix/table.

## Details {#details}

Shift the elements of a vector to the left for one position. In comparison, [prev](../p/prev.md) shifts the elements of a vector to the right for one position; [move](../m/move.md) shifts the elements of a vector for multiple positions.

## Examples {#examples}

``` {#codeblock_jmm_jbh_kfc}
x = 1..5;
next(x);
// output: [2,3,4,5,]
```

``` {#codeblock_s5s_jbh_kfc}
x = matrix(1 2 3 4 5);
next(x)
```

|\#0|
|---|
|2|
|3|
|4|
|5|
||

``` {#codeblock_zpb_lbh_kfc}
t=table(1 2 3 as a, `x`y`z as b, 10.8 7.6 3.5 as c);
next(t)
```

|a|b|c|
|---|---|---|
|2|y|7.6|
|3|z|3.5|
||||

