# nanotimestamp {#nanotimestamp}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`nanotimestamp(X)`

## Arguments {#arguments}

**X** is an integer or temporal scalar/vector.

## Details {#details}

Convert the data type of X to NANOTIMESTAMP. If there is no date in the argument X, return a timestamp from 1970.01.01 00:00:00.000000000 + *X* \(nanoseconds\).

Since version 2.00.12, converting MONTH into NANOTIMESTAMP is allowed.

## Examples {#examples}

```
nanotimestamp(1000000000);
// output: 1970.01.01T00:00:01.000000000

nanotimestamp(2012.12.03 12:06:09 2012.12.03 13:08:01);
// output: [2012.12.03T12:06:09.000000000,2012.12.03T13:08:01.000000000]

nanotimestamp(2012.12.03 01:22:01.123456789);
// output: 2012.12.03T01:22:01.123456789

nanotimestamp('2012.12.03 13:30:10.008007006');
// output: 2012.12.03T13:30:10.008007006

nanotimestamp(2012.01M)
// output: 2012.01.01T00:00:00.000000000
```

Related function: [nanotime](nanotime.md)

