# mwsum {#mwsum}

## Syntax {#syntax}

`mwsum(Y, X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving sums of *X* with *Y* as weights in a sliding window.

The weights in a rolling window are automatically adjusted so that the sum of weights for all non-null elements in the rolling window is 1.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
X1 = 2 1 3 NULL 6 5 4
Y = 1 0.5 1 1 2 2.1

mwsum(X, Y, 3);
// output: [,,5.5,10.5,22,29.5,24.5]

mwsum(X1, Y, 3)
// output: [,,5.5,3.5,15,22.5,24.5]

mwsum(X1, Y, 3, minPeriods=1)
// output: [2,2.5,5.5,3.5,15,22.5,24.5]
```

```
X = 1..10;
Y = 9 5 3 4 5 4 7 1 3 4;
X1 = indexedSeries(date(2020.06.05)+1..10, X)
Y1 = indexedSeries(date(2020.06.05)+1..10, Y)
mwsum(X1, Y1, 5d)
```

|label|col1|
|-----|----|
|2020.06.06|9|
|2020.06.07|19|
|2020.06.08|28|
|2020.06.09|44|
|2020.06.10|69|
|2020.06.11|84|
|2020.06.12|123|
|2020.06.13|122|
|2020.06.14|133|
|2020.06.15|148|

```
mwsum(X1, Y1, 1w)
```

|label|col1|
|-----|----|
|2020.06.06|9|
|2020.06.07|19|
|2020.06.08|28|
|2020.06.09|44|
|2020.06.10|69|
|2020.06.11|93|
|2020.06.12|142|
|2020.06.13|141|
|2020.06.14|158|
|2020.06.15|189|

Related functions: [wsum](../w/wsum.md), [msum](msum.md).

