# mvar {#mvar}

## Syntax {#syntax}

`mvar(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving variances of *X* in a sliding window.

## Examples {#examples}

```
mvar(1..6, 5);
// output: [,,,,2.5,2.5]

mvar(1..6, 5, 2);
// output: [,0.5,1,1.666667,2.5,2.5]
```

```
m=matrix(1 6 2 9 4 5, 11 12 18 23 21 10);
m;
```

|\#0|\#1|
|---|---|
|1|11|
|6|12|
|2|18|
|9|23|
|4|21|
|5|10|

```
mvar(m,3);
```

|\#0|\#1|
|---|---|
|||
|||
|7|14.333333333333314|
|12.333333333333335|30.333333333333314|
|13|6.333333333333372|
|7|49|

```
m=matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2020.04.06)+1..6, `col1`col2)
m.setIndexedMatrix!()
mvar(m,4d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|4.5||
|2020.04.10|4.5|0.5|
|2020.04.11|8||
|2020.04.12|4|32|

```
mvar(m,1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|4.5||
|2020.04.10|4.5|0.5|
|2020.04.11|12.3333|0.5|
|2020.04.12|8.9167|19|

Related functions: [var](../v/var.md)

