# msum {#msum}

## Syntax {#syntax}

`msum(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving sum of *X* in a sliding window.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

msum(X, 3);
// output: [,,6,11,16,18,15]

msum(Y, 3);
// output: [,,6,4,9,11,15]

msum(Y, 3, minPeriods=1);
// output: [2,3,6,4,9,11,15]
```

```
m = matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2020.04.06)+1..6, `col1`col2)
m.setIndexedMatrix!()
msum(m, 3d) // equivalent to msum(m, 3)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|1|9|
|2020.04.08|1|9|
|2020.04.09|5|9|
|2020.04.10|4|10|
|2020.04.11|12|10|
|2020.04.12|14|12|

```
msum(m, 1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|1|9|
|2020.04.08|1|9|
|2020.04.09|5|9|
|2020.04.10|5|19|
|2020.04.11|13|19|
|2020.04.12|19|21|

Related functions: [sum](../s/sum.md)

