# mstdp {#mstdp}

## Syntax {#syntax}

`mstdp(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the population standard deviation of *X* in a sliding window.

## Examples {#examples}

```
mstdp(1 2 5 4 3, 3);
// output: [,,1.699673171197595,1.247219128924647,0.816496580927726]

mstdp(1 2 5 4 3, 3, 2);
// output: [,0.5,1.699673171197595,1.247219128924647,0.816496580927726]

m=matrix(1 6 2 9 4 5, 11 12 18 23 21 10);
m;
```

|\#0|\#1|
|---|---|
|1|11|
|6|12|
|2|18|
|9|23|
|4|21|
|5|10|

```
mstdp(m,3);
```

|\#0|\#1|
|---|---|
|||
|||
|2.160246899469287|3.091206165165233|
|2.867441755680875|4.496912521077346|
|2.943920288775949|2.054804667656331|
|2.160246899469287|5.715476066494082|

```
m=matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2020.04.06)+1..6, `col1`col2)
m.setIndexedMatrix!()
mstdp(m,4d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|0|0|
|2020.04.08|0|0|
|2020.04.09|1.5|0|
|2020.04.10|1.5|0.5|
|2020.04.11|2|0|
|2020.04.12|1.633|4|

```
mstdp(m,1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|0|0|
|2020.04.08|0|0|
|2020.04.09|1.5|0|
|2020.04.10|1.5|0.5|
|2020.04.11|2.8674|0.5|
|2020.04.12|2.586|3.559|

Related function: [mstd](mstd.md)

