# mstd {#mstd}

## Syntax {#syntax}

`mstd(X,window,[minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the standard deviation of *X* in a sliding window.

## Examples {#examples}

```python
mstd(1 2 5 4 3, 3);
// output: [,,2.081666,1.527525,1]

mstd(1 2 5 4 3, 3, 2);
// output: [,0.707107,2.081666,1.527525,1]
```

```python
m=matrix(1 6 2 9 4 5, 11 12 18 23 21 10);
m;
```

|\#0|\#1|
|---|---|
|1|11|
|6|12|
|2|18|
|9|23|
|4|21|
|5|10|

```python
mstd(m,3);
```

|\#0|\#1|
|---|---|
|||
|||
|2.645751311064591|3.78593889720018|
|3.511884584284247|5.507570547286101|
|3.605551275463989|2.516611478423591|
|2.645751311064591|7|

```python
m=matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2020.04.06)+1..6, `col1`col2)
m.setIndexedMatrix!()
mstd(m,4d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|2.1213||
|2020.04.10|2.1213|0.7071|
|2020.04.11|2.8284||
|2020.04.12|2|5.6569|

```python
mstd(m,1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|2.1213||
|2020.04.10|2.1213|0.7071|
|2020.04.11|3.5119|0.7071|
|2020.04.12|2.9861|4.3589|

Related functions: [mmin](mmin.md), [mmax](mmax.md), [mavg](mavg.md), [msum](msum.md), [mvar](mvar.md)

