# mskewTopN {#mskewtopn}

## Syntax {#syntax}

`mskewTopN(X, S, window, top, [biased=true], [ascending=true], [tiesMethod='latest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the moving skewness of the first *top* elements.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
mskewTopN(X, S, 6, 4)
// output: [,0,0,1.01,1.13,0.79,1.08]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
mskewTopN(X, S, 6, 4)

/* output:
col1  col2

0
0       0
0       0
0.4347  0
-0.278  0.4347
-0.4347 0
0       -0.6872
0       0
0       0.4347
*/

symbol = ["A","A","A","B","A","A","B","A","A","B","B","B","A","B","A","B","B","A","B","A"]
time = temporalAdd(2023.07.03T09:30:00.000,[10,20,40,60,70,80,90,140,160,170,180,190,200,210,220,230,250,360,390,400],"ms")
price = [28.11,28.25,28.44,52.31,28.98,28.89,52.22,28.16,28.52,52.62,52.56,52.2,28.01,52.43,28.57,52.42,52.19,28.16,52.84,28.18]
qty = [1900,3300,100,3000,3500,800,3400,4400,3900,4600,2200,2100,2300,4100,400,300,3100,2500,1000,2700]
BSFlag = [1,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,1,1,1,1]
t = table(time, symbol, price, qty, BSFlag)
select time,symbol,BSFlag,mskewTopN(price, qty, 8, 5) as mskewTop5Price from t context by symbol,BSFlag
```

|time|symbol|BSFlag|mskewTop5Price|
|----|------|------|--------------|
|2023.07.03T09:30:00.020|A|0||
|2023.07.03T09:30:00.070|A|0|0|
|2023.07.03T09:30:00.080|A|0|-0.6667|
|2023.07.03T09:30:00.140|A|0|0|
|2023.07.03T09:30:00.160|A|0|0.0904|
|2023.07.03T09:30:00.200|A|0|-0.0986|
|2023.07.03T09:30:00.220|A|0|-0.1794|
|2023.07.03T09:30:00.010|A|1||
|2023.07.03T09:30:00.040|A|1|0|
|2023.07.03T09:30:00.360|A|1|0.6448|
|2023.07.03T09:30:00.400|A|1|1.0153|
|2023.07.03T09:30:00.170|B|0||
|2023.07.03T09:30:00.180|B|0|0|
|2023.07.03T09:30:00.230|B|0|-0.4451|
|2023.07.03T09:30:00.060|B|1||
|2023.07.03T09:30:00.090|B|1|0|
|2023.07.03T09:30:00.190|B|1|0.6156|
|2023.07.03T09:30:00.210|B|1|0.5605|
|2023.07.03T09:30:00.250|B|1|0.8565|
|2023.07.03T09:30:00.390|B|1|1.3966|

Related function: [mskew](mskew.md)

