# mskew {#mskew}

## Syntax {#syntax}

`mskew(X, window, [biased=true], [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#arguments}

**biased** is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Calculate the moving skewness of *X* in a sliding window.

## Examples {#examples}

```
mskew(1 2 3 10 100 4 3, 3);
// output: [,,0,0.665469,0.693810, 0.697217,0.706851]
```

```
m=matrix(1 6 2 9 4 5 100, 100 11 12 18 23 21 10);
m;
```

|\#0|\#1|
|---|---|
|1|100|
|6|11|
|2|12|
|9|18|
|4|23|
|5|21|
|100|10|

```
mskew(m,3);
```

|\#0|\#1|
|---|---|
|||
|||
|0.595170064139498|0.706802122668126|
|-0.172800544078651|0.65201211704403|
|0.470330460336986|-0.110780117654834|
|0.595170064139498|-0.239063146929565|
|0.706845142811354|-0.642723256123865|

```
m.rename!(date(2020.04.06)+1..7, `col1`col2)
m.setIndexedMatrix!()
mskew(m, 3d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|0|0|
|2020.04.09|0.5952|0.7068|
|2020.04.10|-0.1728|0.652|
|2020.04.11|0.4703|-0.1108|
|2020.04.12|0.5952|-0.2391|
|2020.04.13|0.7068|-0.6427|

```
mskew(m, 1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|0|0|
|2020.04.09|0.5952|0.7068|
|2020.04.10|0.2743|1.1373|
|2020.04.11|0.4079|1.4398|
|2020.04.12|0.3298|1.7107|
|2020.04.13|2.0188|1.9363|

Related function: [skew](../s/skew.md)

