# movingWindowIndex {#movingwindowindex}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`movingWindowIndex(X, window, [fixed=false])`

## Arguments {#arguments}

**X** is a vector.

**window** is an integer no less than 2 indicating the window size.

**fixed** is a Boolean value, indicating whether the length of each row in the output array vector is fixed to be *window*. The default value is false. When *fixed* = true, all rows are of the same length. For the first \(*window* - 1\) windows, the indices of missing elements are filled with null values.

## Details {#details}

Return an array vector indicating the indices of the elements of *X* within each sliding window.

## Examples {#examples}

```
S = 1 2 3 4 5 6 7 8 9 0;
m = movingWindowIndex(X=S,window=3);
m;
// output: [[0],[0,1],[0,1,2],[1,2,3],[2,3,4],[3,4,5],[4,5,6],[5,6,7],[6,7,8],[7,8,9]]

mi = movingWindowIndex(X=S,window=3,fixed=true);
mi;
// output: [[,,0],[,0,1],[0,1,2],[1,2,3],[2,3,4],[3,4,5],[4,5,6],[5,6,7],[6,7,8],[7,8,9]]

// obtain the first element from each window
S[m[0]]
// output: [1,1,1,2,3,4,5,6,7,8]

S[mi[0]]
// output: [,,1,2,3,4,5,6,7,8]
```

