# moveReplicas {#movereplicas}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`moveReplicas(srcNode, destNode, chunkId, [destVolumes])`

## Arguments {#arguments}

**srcNode** is a string indicating the alias of origination node.

**destNode** is a string indicating the alias of destination node.

**chunkId** is a string/UUID scalar or vector indicating ID of chunks.

**destVolumes** \(optional\) is a STRING scalar or vector indicating the dest volume\(s\) on the target node. The directories must be included in the configured *volumes*. If a vector is provided, replicas will preferentially be moved to the volume at the beginning of the vector.

## Details {#details}

Move replicas of one or multiple chunks from the source node to the destination node. If the destination node already has the chunk, the command is skipped.

This command can only be executed by an administrator on a controller node.

We can check the execution status with function [getRecoveryTaskStatus](../g/getRecoveryTaskStatus.md).

## Examples {#examples}

Move replicas of all chunks on "node1" to "node2".

```
chunkIds=exec chunkId from pnodeRun(getChunksMeta) where node="node1"
moveReplicas(srcNode="node1",destNode="node2",chunkId=chunkIds,destVolumes="/ddb/server/clusterDemo/data/node2/storage");
```

