# moveChunksAcrossVolume {#movechunksacrossvolume}

**Note:** This function will be deprecated in a future version. We recommend you use the function [moveReplicas](moveReplicas.md).

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`moveChunksAcrossVolume(srcPath, destPath, chunkIds, [isDelSrc=true])`

## Arguments {#arguments}

**srcPath** is a string in the format of *volumeA/CHUNKS*, indicating the source volume of the chunks.

**destPath** is a string in the format of *volumeB/CHUNKS*, indicating the destination volume of the chunks.

**chunkIds** is a string scalar or vector, indicating the chunk IDs to be moved.

**isDelSrc** is a Boolean value indicating whether to delete the source volume after copying the chunks. The default value is true.

Note: *srcPath*, *destPath*, and *chunkIds* can be obtained with function [getChunksMeta](../g/getChunksMeta.md).

## Details {#details}

Move the chunks from the source volume to the destination volume on the same node. When *isDelSrc* = true, chunks are moved to the destination volume, otherwise they are copied. If the transfer fails, all chunks of the source volume are retained, and chunks that have been copied are removed from the destination volume.

**Note:**

-   Chunks can only be moved within the same node.
-   Before moving the chunks, make sure that there is no writing process on the current node, all transactions have been completed, and all buffers have been synchronized to the disk.

-   The configuration parameter *volumes* must contain the volumes specified by parameters *scrPath* and *destPath*. The server must be rebooted after the configuration parameters are modified for them to take effect.

-   The volume specified by *destPath* must be empty.


