# monthBegin {#monthbegin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`monthBegin(X, [offset], [n=1])`

Alias: `monthStart`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**offset** is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** is a positive integer. The default value is 1.

## Details {#details}

Return the first day of the month that *X* belongs to.

If parameter *offset* is specified, the result is updated every *n* months. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```
monthBegin(2016.12.06);
// output: 2016.12.01

date=2016.04.12 2016.04.25 2016.05.12 2016.06.28 2016.07.10 2016.07.18 2016.08.02 2016.08.16 2016.09.26 2016.09.30
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

t1;
```

|date|time|sym|qty|price|
|----|----|---|---|-----|
|2016.05.12|09:30:00|MSFT|2200|49.6|
|2016.06.11|09:30:00|MSFT|1900|29.46|
|2016.07.11|09:30:00|MSFT|2100|29.52|
|2016.08.10|09:30:00|MSFT|3200|30.02|
|2016.09.09|09:30:00|MSFT|6800|174.97|
|2016.10.09|09:30:00|MSFT|5400|175.23|
|2016.11.08|09:30:00|MSFT|1300|50.76|
|2016.12.08|09:30:00|MSFT|2500|50.32|
|2017.01.07|09:30:00|MSFT|8800|51.29|
|2017.02.06|09:30:00|MSFT|4500|52.38|

```
select avg(price),sum(qty) from t1 group by monthBegin(date,2016.01.01,2);
```

|monthBegin\_date|avg\_price|sum\_qty|
|----------------|----------|--------|
|2016.03.01|39.53|4100|
|2016.05.01|29.77|5300|
|2016.07.01|112.82|16000|
|2016.09.01|51.835|13300|

Related functions: [monthEnd](monthEnd.md), [businessMonthBegin](../b/businessMonthBegin.md), [businessMonthEnd](../b/businessMonthEnd.md), [semiMonthBegin](../s/semiMonthBegin.md), [semiMonthEnd](../s/semiMonthEnd.md)

