# mode {#mode}

## Syntax {#syntax}

`mode(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, calculate the most frequently occurring value in *X*.

If *X* is a matrix/table, calculate the most frequently occurring value in each column of *X* and return a vector/table.

This function counts the occurrences of unique values \(keys\) in *X* using a hash table. If there are multiple keys with the highest count, the function returns the first key in the hash table. Note that the hash algorithm used by this function varies for different data types, so the output results may differ.

As with all aggregate functions, null values are not included in the calculation.

## Examples {#examples}

```
mode 2;
// output: 2

mode 1 3 3 3 4 5 5;
// output: 3

mode `test;
// output: test

m=matrix(1 1 2 2 2 3, 4 4 5 6 6 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|1|4|
|2|5|
|2|6|
|2|6|
|3|6|

```
mode m;
// output: [2,6]
```

Related functions: [mean](mean.md) and [med](med.md)

