# mmin {#mmin}

## Syntax {#syntax_mmin}

`mmin(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving minimums of *X* in a sliding window.

## Examples {#examples}

``` {#codeblock_iyf_5hn_ryb}
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

mmin(X, 3);
// output: [,,1,1,3,5,4]

mmin(Y, 3);
// output: [,,1,1,3,5,4]

mmin(Y, 3, minPeriods=1);
// output: [2,1,1,1,3,5,4]
```

``` {#codeblock_jyf_5hn_ryb}
m = matrix(1 5 9 0 2 8 -1 5, 9 10 2 NULL -1 10 2 3)
m.rename!(date(2020.09.10)+1..8, `A`B)
m.setIndexedMatrix!()
m.mmin(3d)
```

|label|col1|col2|
|-----|----|----|
|2020.09.11|1|9|
|2020.09.12|1|9|
|2020.09.13|1|2|
|2020.09.14|0|2|
|2020.09.15|0|\(1\)|
|2020.09.16|0|\(1\)|
|2020.09.17|\(1\)|\(1\)|
|2020.09.18|\(1\)|2|

``` {#codeblock_lyf_5hn_ryb}
m.mmin(1w)
```

|label|col1|col2|
|-----|----|----|
|2020.09.11|1|9|
|2020.09.12|1|9|
|2020.09.13|1|2|
|2020.09.14|0|2|
|2020.09.15|0|\(1\)|
|2020.09.16|0|\(1\)|
|2020.09.17|\(1\)|\(1\)|
|2020.09.18|\(1\)|\(1\)|

Related function: [min](min.md)

